#!/usr/bin/perl
### Best with Perl 5.6 or better
#  Path to Perl - you may need to check your server admin just in case
#  it is different.
##########################################################################
#  Weblog Script Based on:
#  DForum 1.01 (11/02/1999)
#  http://www.dansteinman.com/dforum
#  Copyright (C) 1998 Dan Steinman
#
#  This version by Ted Hawkins, Forum2.6, January 2003
#  http://scriptles.bluwall.com
#   Including
#   1) Footer script by Michael Mathews, August 2002
#      http://perlcircus.com
#
#   2) Latest reply to a subject posting
#      by Jeff Thomas, December 2002
#      http://www.jhthomas.net
#      Jeff redid the original Dforum1 this way at www.roigi.com
#      and it has been written into Forum2 as of Version 2.5
#   
#   3) PerlBlog v1.05 by Rio Akasaka, May 2003-March 2005
#      Altered Forum2.6 into a customizable and flexible 
#      weblog.
#
#      http://www.chronicled.org/perlblog
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  any later version.
#  
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License (license.txt) for more details.
#  
#
###################### GENERAL SETTINGS #################################
require 'weblog-config.cgi';
$header = "$forumdir/header.txt";
#########################################################################
$numnths = "2";
# parse form values
read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
@pairs = split(/&/, $buffer);
foreach $pair (@pairs) {
	local($name, $value) = split(/=/, $pair);
	$value =~ tr/+/ /;
	$value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
	$value =~ s/<!--(.|\n)*-->//g;
	$in{$name} = $value;
}
##########################################################################
# miscellaneous values
# time is Greenwich Mean Time (GMT)
($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = gmtime(time);
$year = 1900 + $year;
$lastyear = ($year - 1);	                                      #JHT added lastyear
$dec = "12";                                                 # Use for December at year change
$lastmonth = $mon;
$today= $mday;
$yesterday= ($mday - 1);
$thismonth = ($mon + 1);
if ($lastmonth <10) {$lastmonth = "0$lastmonth";}
if ($thismonth <10) {$thismonth = "0$thismonth";}
if ($mday <10) {$mday = "0$mday";}
if ($hour<10) {$hour = "0$hour";}
if ($min<10) {$min = "0$min";}
$todaysdate = "$thismonth/$mday/$year-$hour:$min";
$todaysday = "$mday";
$newheaderfile = "$year$thismonth";
@months = ("January","February","March","April","May","June","July","August","September","October","November","December");

##########################################################################
# determine what sub-routine to run based on the $command query string
if ($ENV{'QUERY_STRING'} ne '') {
	@qstr = split (/=/,$ENV{'QUERY_STRING'});
	$command = $qstr[0];
	$value = $qstr[1];
	$value =~ s/[\x00-\x20<>\|;\(\)\$^\+!\^\[\]\?\"\'\`]//g;
	
	if ($command eq "archives") {&displayArchives;}
	elsif ($command eq "month") {&displayMonth ($value);}
	elsif ($command eq "msg") {&displayMessage ($value);}
	elsif ($command eq "submitrio1005") {&displaySubmit;}
	elsif ($command eq "reply") {&displayReply ($value);}
	elsif ($command eq "preview") {&displayPreview;}
	else {&displayDefault;}
}
else {
	# if no query string check for a 'post' form value (needed when posting a new thread or reply)
	if ($in{'post'}) {&postMessage;}
	# print the default page
	else {&displayDefault;}
}
################### USERNAME AND PASSWORD CHECK ##############################
sub checkAccess {
	if ($in{'username'} ne $username || $in{'password'} ne $password) {
		print "Content-type: text/html\n\n";
		print "Access Denied";
		exit(0);
	}
}

##################### JOURNAL ENTRY PREVIEW PAGE #######################
sub displayPreview {
      &checkAccess;
	$name = $in{'name'};
	$name =~ s/</&lt;/g;
	$name =~ s/>/&gt;/g;
	$name =~ s/"/&quot;/g;
	$name =~ s/\n/<br>/g;
                  $name =~ s/\cM//g;
	$image = $in{'image'};
	$image =~ s/</&lt;/g;
	$image =~ s/>/&gt;/g;
	$image =~ s/"/&quot;/g;
	$postm= $in{'postm'};
	$postm =~ s/</&lt;/g;
	$postm =~ s/>/&gt;/g;
	$postm =~ s/"/&quot;/g;
	$email = $in{'email'};
	$email =~ s/<([^>]|\n)*>//g;
 $website = $in{'website'};
 $website =~ s/<([^>]|\n)*>//g;
	$date= $in{'date'};
	$headerfile = $in{'headerfile'};
	$subject = $in{'subject'};
	$reply = $in{'reply'};
 $body = &wrapText($in{'body'},$textwidth);
	$body =~ s/\cM//g;
	$bodyshow = $body;
	$body =~ s/</&lt;/g;
	$body =~ s/>/&gt;/g;
	$body =~ s/"/&quot;/g;

	if ($html eq "no") {
		$bodyshow =~ s/<([^>]|\n)*>//g;
	}
	if ($html eq "yes") {
		$bodyshow =~ s/</&lt;/g;
		$bodyshow =~ s/>/&gt;/g;
		$bodyshow =~ s/"/&quot;/g;
	}

	$subject =~ s/\cM//g;
	$subject =~ s/<([^>]|\n)*>//g;
	$subject =~ s/"/&quot;/g;
	$subject =~ s/_/ /g;

	&printHeader("");
	if ($name) {
		print "\n";
		if ($email) {
			print "\n";

  if ($website) {
			print " (#$website)\n";
		}
		}

		print <<"EOF";
<table cellpadding="10" cellspacing="1" border="0" width="50%" align="center" class="border">
  <tr>
    <td width="0%" valign="top" colspan="2"><br>Previewing entry<BR>
<BR><h2>$subject</h2>
$name
<BR>Date: $date
<BR> $bodyshow</span>
<FORM NAME="forum" METHOD=POST ACTION="weblog.cgi">
<INPUT TYPE="HIDDEN" NAME="date" VALUE="$date">
<INPUT TYPE="HIDDEN" NAME="headerfile" VALUE="$headerfile">
<INPUT TYPE="HIDDEN" NAME="name" VALUE="$name">
<INPUT TYPE="HIDDEN" NAME="image" VALUE="$image">
<INPUT TYPE="HIDDEN" NAME="postm" VALUE="$postm">
<INPUT TYPE="HIDDEN" NAME="email" VALUE="$email">
<INPUT TYPE="HIDDEN" NAME="website" VALUE="$website">
<INPUT TYPE="HIDDEN" NAME="subject" VALUE="$subject">
<INPUT TYPE="HIDDEN" NAME="body" VALUE="$body">

<P><BR>
<INPUT class="submit" TYPE="Button" VALUE="Edit" onClick="history.back()">
<INPUT class="submit" TYPE="Submit" VALUE="Post Entry">
EOF
		if ($reply) {
			print "<INPUT TYPE=\"Hidden\" NAME=\"post\" VALUE=\"reply\">\n";
			print "<INPUT TYPE=\"Hidden\" NAME=\"reply\" VALUE=\"$reply\">\n";
		}
		else {
			print "<INPUT TYPE=\"Hidden\" NAME=\"post\" VALUE=\"thread\">\n";
		}
		print "</FORM></td></tr></table>\n";
	}
	else {
		print "
<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" align=\"center\" width=\"0\" height=\"45\"></table>
<table cellpadding=\"10\" cellspacing=\"1\" border=\"0\" width=\"50%\" align=\"center\" class=\"border\"><tr><td width=\"0%\" vAlign=\"top\" colspan=\"2\">
<BR><span class=\"header\"><B>Error</B> | <A HREF=\"weblog.cgi\"><B>Return to Weblog</b></A></span><BR><BR><BR><span class=\"text\">Error: You are required to give a name, an email address and a message<P><BR><INPUT class=\"submit\" TYPE=\"Button\" VALUE=\"Edit\" onClick=\"history.back()\">
";
             }
	&printFooter;
}

###################### WORD WRAP ########################
sub wrapText {
	my($body,$length) = @_;
	@lines = split(/\n/,$body);
	$newstr = "";
	for ($i=0; $i<@lines; $i++) {
		@words = split(/ /,@lines[$i]);
		$block = $words[0];
		for ($j=1; $j<@words; $j++) {
			$word = $words[$j];
			$test = $block." ".$word;
			if (split(//,$test) < $length+1) {
				$block = $block." ".$word;
			}
			else {
				$newstr = $newstr.$block."\n";
				$block = $word;
			}
		}
		$newstr = $newstr.$block."\n";
	}
	return ($newstr);
}

####################### DETERMINES ENTRY/REPLY STATUS #######################
sub postMessage {
	$name = $in{'name'};
                  $name =~ s/\n/<br>/g;
                  $name =~ s/\cM//g;
	$postm = $in{'postm'};
                  $image = $in{'image'};
	$email = $in{'email'};
	$website = $in{'website'};
	$date = $in{'date'};
	$headerfile = $in{'headerfile'};
	$reply = $in{'reply'};
		
	$body = $in{'body'};
	$body =~ s/\cM//g;
	if ($html eq "no") {
		$body =~ s/<([^>]|\n)*>//g;
	}
	if ($html eq "yes") {
		$body =~ s/</&lt;/g;
		$body =~ s/>/&gt;/g;
		$body =~ s/"/&quot;/g;
	}
	
	$subject = $in{'subject'};
	$subject =~ s/\cM//g;
	$subject =~ s/"/&quot;/g;
	$subject =~ s/_/ /g;
	if ($in{'post'} eq "thread") {&postThread;}
	elsif ($in{'post'} eq "reply") {&postReply;}

	&printHeader ("");
	if ($reply) {$message = $reply;}
	else {$message = $num;}
	print <<"EOF";
<table border="0" cellspacing="0" cellpadding="0" align="center" width="0" height="45"></table>
<table cellpadding=10 cellspacing='1' border='0' width='50%' align='center' class="border"><tr><td width="0%" vAlign="top" colspan="2">
<BR>
<span class="header"><B>Success</B> | <A HREF="weblog.cgi"><B>Return to Weblog</b></A></span>
<BR><BR><BR><SPAN CLASS="text">Your comment has been posted!
<BR><BR><A HREF="weblog.cgi">Return to weblog</A><BR><BR></SPAN>
EOF
	&printFooter;
}

###################### POSTS JOURNAL ENTRY AND RETURNS TO WEBLOG.PL ############################
sub postThread {
	if (!opendir (DIR, "$forumdir")) {
		mkdir ("$forumdir", 0700);
	}
	open(NUM,"$forumdir/num.txt");
	$num = <NUM>;
	$num += 1;
	close(NUM);
	open(NUM,">$forumdir/num.txt");
	print NUM $num;
	close(NUM);
	
	open(MONTHS,"$forumdir/months.txt");
	@months = <MONTHS>;
	close(MONTHS);
	$addit = "true";
	foreach $month (@months) {
		if ($month =~ /$headerfile/) {
			$addit = "false";
		}
	}
	if ($addit eq "true") {
		open(MONTHS,"$forumdir/months.txt");
		@monthlines = <MONTHS>;
		close(MONTHS);
		open(MONTHS,">$forumdir/months.txt");
		unshift (@monthlines, "$headerfile\n");
		foreach $monthline (@monthlines) {
			print MONTHS $monthline;
		}
		close(MONTHS);
	}
	
	open(HEADER,"$forumdir/$headerfile.txt");
	@headers = <HEADER>;
	close(HEADER);
	open(HEADER,">$forumdir/$headerfile.txt");
	unshift (@headers, "$num\_$subject\_$name\_$image\_$postm\_$date\_0\_&nbsp;\n");  # JHT modified: last field - &nbsp;
	foreach $headerline (@headers) {
		print HEADER $headerline;
	}
	close(HEADER);
	if (!opendir (DIR, "$forumdir/messages")) {
		mkdir ("$forumdir/messages", 0777);
	}
	open(NEWTHREAD,">$forumdir/messages/$num.txt");
	print NEWTHREAD <<"EOF";
<threadinfo>
<num>$num</num>
<headerfile>$headerfile</headerfile>
<subject>$subject</subject>
</threadinfo>

<msg>
<name>$name</name>
<email>$email</email>
<website>$website</website>
<date>$date</date>
<image>$image</image>
<body>
$body
</body>
</msg>
EOF
	close(NEWTHREAD);
}

##################### POSTS A REPLY (NEEDED) ############################
sub postReply {
	open(HEADER,"$forumdir/$headerfile.txt");
	@headers = <HEADER>;
	close(HEADER);
	open(HEADER,">$forumdir/$headerfile.txt");
	foreach $headerline (@headers) {
		@headerdata = split(/_/, $headerline);
		$threadnum = $headerdata[0];
		if ($threadnum == $reply) {
			@headerdata = split(/_/, $headerline);
			$responses = $headerdata[6];
			$responses += 1;
			$replytime = $date;    # replytime is JHT addition
			print HEADER "$headerdata[0]\_$headerdata[1]\_$headerdata[2]\_$headerdata[3]\_$headerdata[4]\_$headerdata[5]\_$responses\_&nbsp;\n";
		}
		else {print HEADER "$headerline";}
	}
	close(HEADER);

	open(REPLY,">>$forumdir/messages/$reply.txt");
	print REPLY <<"EOF";

<msg>
<name>$name</name>
<email>$email</email>
<website>$website</website>
<date>$date</date>
<body>
$body
</body>
</msg>
EOF
	close(REPLY);
}

##########################################################################
# common HTML header for all pages
sub printHeader {
	my($title) = @_;
print "Content-type: text/html\n\n";
	print <<"EOF";
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">

<html xmlns="http://www.w3.org/1999/xhtml" lang="en" xml:lang="en">
<TITLE>$blogtitle</TITLE>
<head>
<!-- STYLE OF YOUR WEBLOG DO NOT EDIT --!>
<style>
html { height: 100%; }
* { padding: 0; border: 0; margin: 0; }
body { font-family: $bodyfont; background-color: $bgcolor;font-size:$fontsz; color:$bodycolor;border: 0px; height: 100%; margin: 0px; padding: 0px;letter-spacing: 0px; line-height: 1.5em; }
.body p {font-family:$bodyfont; color:$bodycolor;font-size:$bodyesize }
.body { margin-bottom: 2em; margin-top: 1em; } 
.body { text-align:justify; }
.top { width: $width; height:$height; background: $bgtopcolor url($headerimg) no-repeat top center; margin: 0 auto; }
.top p { padding-top:$paddingtp; padding-left:$paddinglft; }
.footer { width: $width; height:$footerheight; background: $footercolor url($footerimg) no-repeat bottom center;  }
.footer p { padding-top:10px; padding-left:$paddinglft; color:$footertxt; }
.banner { width: $width; background: $maincolor  repeat-y center url($bgimg); margin: 0 auto; }
#areabox {width: $jwidth;  margin-bottom: 60px;padding-top:10px; padding-left:$paddinglft; padding-bottom: 20px; min-height: 400px}
#sidebar { background-color:$sidebarcolor;float: $direction; width: $swidth;padding-top:10px; padding-right:$paddingr; padding-left:$paddingl; }
p a.subtitle:link, p a.subtitle:visited, p a.subtitle:active {font-family:$subttfont;text-decoration: none; color: $subttcolor; font-size:$subtitlesize; text-decoration:$subttdeco; font-weight:$subtitlewg;}
p a.subtitle:hover {font-family:$subtthfont;text-decoration: none; color: $subtthcolor; font-size:$subtitlehsize; text-decoration:$subtthdeco; font-weight:$subtitlehpwg;}
p a.title:link, p a.title:visited, p a.title:active {font-family:$headertitlefont;text-decoration: none; 
color:$headertitlecolor;font-size:$titlesize;font-weight:$headertitlewg;border-bottom: none;}
h2, .h2 {font-family: $titlefont; font-size: $tentrysize; line-height: normal; padding-bottom:0.3em;font-weight: bold; color: #$titlecolor;}
.comments {font-family:$bodyfont;border-bottom-color: $bodycolor; border-bottom-style: dotted; border-bottom-width: 1px; padding-bottom: 3px; margin-top: 3px; margin-bottom: 10px; border-color: $bodycolor; } 
.section { font-family: $sectionfont; font-size: $sectionsize; text-align: left; line-height: 1.4em; margin-bottom: 22px; color: $sectionclr; }
.tag {font-family:$tagfont; font-weight:$tagweight; color:$tagcolor; font-size:$tagfontsize;}
a:link, a:visited, a:active { text-decoration: $linkdeco; color: $linkcolor;font-weight:$linkweight; }
a:hover{ text-decoration: $txtdecohover; color:$hover; font-weight:$fntweight; }
img { border: none; }
p img { padding:$imgpadding; border:1px solid $imgborder; background-color:$imgback; }
p { margin: 0 0 12px 0; padding: 0; }
textarea { width: 340px; }
input.txt { background-color:$inputbg; border: 1px $inputborder solid; padding: 1px; font: $inputfsize $inputfont; color: $inputcolor; }
textarea.entrytext { background-color:$inputbg;overflow: hidden; border: 1px $inputborder solid; padding: 1px; font: $inputfsize $inputfont; color: $inputcolor; }
input.submit { font-family:$submitfont; font-size:$submitfontsize; background-color: $submitbg; color:$submitfontcolor; border-top: $submitborder 1px solid; border-left:$submitborder 1px solid; border-right: $submitborder 1px solid; border-bottom: $submitborder 1px solid; }
.section .caption {border-bottom-color: $bodycolor; border-bottom-style: dotted; border-bottom-width: 1px; font-weight: $sidefweight; font-size: $sectionfsize; font-family: $sectiontfont; padding-bottom: 3px; margin-top: 3px; margin-bottom: 10px; color: $sidecolor; border-color: $bodycolor; }
.section p { margin: 0 0 10px 0; padding: 0; line-height:1.4em; }
.description p { margin: 0 0 10px 0; padding: 0; line-height:1.4em; text-align:justify; }
input.ed_button {margin-left:3px; margin-bottom:3px; background-color:#ffffff; border: 1px #4b4b4b solid; padding: 1px; font: 11px Georgia; color: #333333; }
</style>
</head>
<body>
<div class="top">
<!-- TITLE OF YOUR BLOG --!>
<p><a href="weblog.cgi" class="title">$blogtitle</a><br /><a href="weblog.cgi" class="subtitle">$subtitle</a></p><p>
<!-- LINKS TO YOUR PAGES --!>
                    [ <a href="weblog.cgi" class="subtitle">main</a> | 
                      <a href="?archives" class="subtitle">archives</a> | 
                      <a href="?about" class="subtitle">about</a> ]</P>
</div>
<div class="banner">
EOF
# Call header file
	open HEADER, "$header"
         or die "Can't open header file because $!\n";
     print while (<HEADER>);
	close HEADER;

}
##########################################################################
# common HTML footer for all pages
 sub printStylefile {
	print <<"EOF";
EOF
                  open SIDEBAR, "$forumdir/style.txt"
         or die "Can't open header file because $!\n";
     print while (<SIDEBAR>);
	close SIDEBAR;
}
 sub printFooter {
 print <<"EOF";
<div class="footer"><p>
EOF
    open FOOTER, "$forumdir/footer.txt"
         or die "Can't open footer file because $!\n";
     print while (<FOOTER>);
    close FOOTER;
}
    print "\n</body></html>\n\n";