#!/usr/bin/perl
### Best with Perl 5.6 or better
##########################################################################
#  Forum2 Development Overview
#  DForum 1.01 (11/02/1999)
#  http://www.dansteinman.com/dforum
#  Copyright (C) 1998 Dan Steinman
#
#  This version by Ted Hawkins, Forum2.6, January 2003
#  http://scriptles.bluwall.com
#   Including
#   1) Footer script by Michael Mathews, August 2002
#      http://perlcircus.com
#
#   2) Latest reply to a subject posting
#      by Jeff Thomas, December 2002
#      http://www.jhthomas.net
#      Jeff redid the Original Dforum1 this way at www.roigi.com
#      and it has been written into Forum2 as of Version 2.5
#
#   3) PerlBlog v1.05 by Rio Akasaka, May 2003-March 2005
#      Altered Forum2.6 into a customizable and flexible 
#      weblog.
#
#      http://www.chronicled.org/perlblog
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  any later version.
#  
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License (license.txt) for more details.
#  
##########################################################################
#
# Forum Administration Script
# filename:     weblog-admin.cgi
# description:  Deletes or edits the messages in the forum
#
##########################################################################
require 'weblog-config.cgi';
$header = "$forumdir/header.txt";
##########################################################################

################      NO EDITING NEEDED BELOW HERE     ###################
##########################################################################
#

##########################################################################
# parse form values
read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
@pairs = split(/&/, $buffer);
foreach $pair (@pairs) {
	local($name, $value) = split(/=/, $pair);
	$value =~ tr/+/ /;
	$value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
	$value =~ s/<!--(.|\n)*-->//g;
	$in{$name} = $value;
}

##########################################################################
# miscellaneous values
$command = $in{'command'};
@months = ("January","February","March","April","May","June","July","August","September","October","November","December");

##########################################################################
# determine what sub-routine to run based on the $command form value
if ($command eq '') {&login;}
elsif ($command eq 'displayList') {&displayList;}
elsif ($command eq 'displayThreads') {&displayThreads;}
elsif ($command eq 'deleteThreads') {&deleteThreads;}
elsif ($command eq 'displayEditThread') {&displayEditThread;}
elsif ($command eq 'editThread') {&editThread;}

##########################################################################
# prints the login page
sub login {
	&printHeader("$forumclass");
	print <<"EOF";
<tr><td><table cellpadding="10" cellspacing="1" border="0" width="410" class="border"><tr><td colspan="0" bgcolor="white"><BR><table width="410" border="0" cellspacing="1" cellpadding="0" bordercolor="white"><table width="410" align="center" border="0" cellspacing="0" cellpadding="0"><span class="header"><B>Weblog-admin please Login</B> </span><BR><BR>
	<FORM ACTION="weblog-admin.cgi" METHOD="POST">
	<INPUT TYPE="Hidden" NAME="command" VALUE="displayList">
	<TABLE BORDER=0 CELLSPACING=1 CELLPADDING=1>
	<TR><TD BGCOLOR="#FFFFFF" CLASS="txt">Username:</TD>
 <TD BGCOLOR="#FFFFFF"><INPUT TYPE="Text" CLASS="txt" NAME="username" SIZE="20"></TD></TR>
	<TR><TD BGCOLOR="#FFFFFF" CLASS="txt">Password:</TD>
 <TD BGCOLOR="#FFFFFF"><INPUT TYPE="Password" CLASS="txt" NAME="password" SIZE="20"></TD></TR>
	<TR><TD BGCOLOR="#FFFFFF" CLASS="headers"><BR><BR><INPUT TYPE="Submit" CLASS="submit" VALUE="Login"></TD></TR>
	</TABLE>
	</FORM><BR></font></span><span class="headerss">Return to your weblog by clicking <A HREF="weblog.cgi">here</A></tr></table></td></tr></td></tr></table><BR><BR>
EOF
	&printFooter;
}

##########################################################################
# checks username and password, called from every sub-routine
sub checkAccess {
	if ($in{'username'} ne $adminusername || $in{'password'} ne $adminpassword) {
		print "Content-type: text/html\n\n";
		print "Access Denied";
		exit(0);
	}
}

##########################################################################
# prints a list of months that have been archived
sub displayList {
	&checkAccess;
	&printHeader("");
	print "<FORM ACTION=\"weblog-admin.cgi\" METHOD=\"POST\">\n";
	open(MONTHS,"$forumdir/months.txt");
	@headerfiles = <MONTHS>;
	close(MONTHS);
	print <<"EOF";
<tr><td><table cellpadding="10" cellspacing="1" border="0" width="410" class="border"><tr><td colspan="0" bgcolor="white"><BR><table width="410" border="0" cellspacing="1" cellpadding="0" bordercolor="white"><table width="410" align="center" border="0" cellspacing="0" cellpadding="0"><span class="header"><B>Choose Month to Edit</B> </span><BR><BR>
	<TABLE BORDER=0 CELLSPACING=1 CELLPADDING=1>
	<TR BGCOLOR="#FFFFFF"><TD CLASS="headers">Month</TD><TD CLASS="headers">Year</TD></TR>
EOF
	foreach $headerfile (@headerfiles) {
		if ($headerfile ne '') {
			$year = substr ($headerfile,0,4);
			$month = substr ($headerfile,4,5);
			$month = sprintf("%5.0f", $month);
			$monthname = $months[$month-1];
			$headerfile = substr ($headerfile,0,6);
			print "<TR BGCOLOR=\"#FFFFFF\"><TD><INPUT TYPE=\"Radio\" NAME=\"headerfile\" VALUE=\"$headerfile\">$monthname&nbsp;&nbsp;</TD><TD>$year</TD></TR>\n";
		}
	}
	print <<"EOF";
	<INPUT TYPE="Hidden" NAME="username" VALUE="$in{username}">
	<INPUT TYPE="Hidden" NAME="password" VALUE="$in{password}">
	<INPUT TYPE="Hidden" NAME="command" VALUE="displayThreads">
	<TR BGCOLOR="#FFFFFF"><TD><BR><BR><INPUT TYPE="Submit" class="submit" VALUE="Edit Month"></TD></TR>
	</TABLE>
	</FORM>
EOF
	&printFooter;
}

##########################################################################
# print the headers for a particular month
sub displayThreads {
	&checkAccess;
	$headerfile = $in{'headerfile'};

	$year = substr ($headerfile,0,4);
	$month = substr ($headerfile,4,5);
	$month = sprintf("%5.0f", $month);
	$monthname = $months[$month-1];
	
	open(DATA,"$forumdir/$headerfile.txt");
	@headerlines = <DATA>;
	close(DATA);
	$length = @headerlines;

	&printHeader("");
	print <<"EOF";
	<SCRIPT LANGUAGE="JavaScript">
	<!--
	
	function submitForm(which) {
		df = document.forum
		if (which == 'delete') {
			var str = ""
			for (var i=0; i<$length; i++) {
				if (eval('df.delete'+i+'.checked == true')) {
					str += eval('df.delete'+i+'.value')+","
				}
			}
			if (str!="") {
				df.todelete.value = str.substring(0,str.length-1)
				df.command.value = "deleteThreads"
				df.submit()
			}
			else alert('Error: no threads to delete are selected')
		}
		else if (which == 'edit') {
			var editselected = false
			for (var i=0; i<df.toedit.length; i++) {
				if (df.toedit[i].checked == true) {
					editselected = true
					break
				}
			}
			if (editselected == false) alert('Error: no thread to edit is selected')
			else {
				df.command.value = "displayEditThread"
				df.submit()
			}
		}
	}
	
	//-->
	</SCRIPT>

<tr><td><table cellpadding="10" cellspacing="1" border="0" width="410" class="border"><tr><td colspan="0" bgcolor="white"><BR><table width="410" border="0" cellspacing="1" cellpadding="0" bordercolor="white"><table width="410" align="center" border="0" cellspacing="0" cellpadding="0"><span class="header"><B>Editing/Deleting Entries</B> | <A HREF="weblog.cgi"><B>$monthname $year</b></A></span><center><BR><BR>
	<TABLE BORDER=0 width="650" CELLSPACING=1 CELLPADDING=1>
	<TR BGCOLOR="#FFFFFF"><TD class="border">&nbsp;Delete</TD><TD class="border">&nbsp;Edit</TD><TD class="border">&nbsp;Subject</TD><TD class="border">&nbsp;Entry</TD><TD CLASS="headers">Responses</TD>
	<FORM NAME="forum" ACTION="weblog-admin.cgi" METHOD="POST">
EOF
	for ($i=0;$i<@headerlines;$i++) {
		if ($headerlines[$i] ne '') {
			@info = split (/_/, $headerlines[$i]);
			$num = $info[0];
			$subject = $info[1];
			$name = $info[2];
			$date = $info[3];
			$responses = $info[4];
			print <<"EOF";
			<TR BGCOLOR="#FFFFFF"><TD ALIGN="CENTER"><INPUT TYPE="Checkbox" NAME="delete$i" VALUE="$num"></TD>
			<TD ALIGN="CENTER"><INPUT TYPE="Radio" NAME="toedit" VALUE="$num"></TD>
			<TD>&nbsp;$subject&nbsp;</TD><TD>&nbsp;$name&nbsp;</TD><TD ALIGN="CENTER">$responses</TD></TR>
EOF
		}
	}
	print <<"EOF";
	<TR BGCOLOR="#FFFFFF">
	<TD><BR><BR><INPUT TYPE="BUTTON" class="submit" VALUE="Delete" onClick="submitForm('delete')"></TD>
	<TD><BR><BR><INPUT TYPE="BUTTON" class="submit" VALUE="Edit" onClick="submitForm('edit')"></TD>
	</TR>
	</TABLE>
	<INPUT TYPE="HIDDEN" NAME="todelete">
	<INPUT TYPE="HIDDEN" NAME="headerfile" VALUE="$headerfile">
	<INPUT TYPE="HIDDEN" NAME="username" VALUE="$in{username}">
	<INPUT TYPE="HIDDEN" NAME="password" VALUE="$in{password}">
	<INPUT TYPE="HIDDEN" NAME="command" VALUE="">
	</FORM>
EOF
	&printFooter;
}

##########################################################################
# prints the edit thread page, where you edit the source file to a message
sub displayEditThread {
	&checkAccess;
	$headerfile = $in{'headerfile'};
	$toedit = $in{'toedit'};
	$toedit =~ s/[\x00-\x20<>\|;\(\)\$^\+!\^\[\]\?\"\'\`]//g;
	&printHeader("");
	print <<"EOF";
<tr><td><table cellpadding="10" cellspacing="1" border="0" width="410" class="border"><tr><td colspan="0" bgcolor="white"><BR><table width="410" border="0" cellspacing="1" cellpadding="0" bordercolor="white"><table width="410" align="center" border="0" cellspacing="0" cellpadding="0"><span class="header"><B>Editing/Deleting Entries</B> | <A HREF="weblog.cgi"><B>Thread $toedit</b></A><br><font size="1">Edit within the first  &lt;name&gt; parameters for the actual blog entry<br>Comments follow blog entry</font></span><center><BR><BR></B>
	<FORM NAME="forum" ACTION="weblog-admin.cgi" METHOD="POST">
	<TEXTAREA NAME="body" STYLE="overflow:hidden" class="txt" ROWS=20 COLS=65>
EOF
	open(DATA,"$forumdir/messages/$toedit.txt");
	@msglines = <DATA>;
	close(DATA);
	foreach $msgline (@msglines) {
		print $msgline;
	}
	print "</TEXTAREA>\n";
	print <<"EOF";
	<BR>
	<INPUT TYPE="HIDDEN" NAME="toedit" VALUE="$toedit">
	<INPUT TYPE="HIDDEN" NAME="headerfile" VALUE="$headerfile">
	<INPUT TYPE="HIDDEN" NAME="username" VALUE="$in{username}">
	<INPUT TYPE="HIDDEN" NAME="password" VALUE="$in{password}">
	<INPUT TYPE="HIDDEN" NAME="command" VALUE="editThread"><BR><BR>
	<INPUT TYPE="Submit" class="submit" VALUE="Save Entry">
	</FORM>
EOF
	&printFooter;
}

##########################################################################
# sub-routine of &displayPreview that wraps a block of text to a given line length
# Deleted to see if it affect runing on Linux. Works okay on NTP on PC with Apache
# Not needed for admin

##########################################################################
# saves the message that was being edited
sub editThread {
	&checkAccess;
	&printHeader("");
	$headerfile = $in{'headerfile'};
	$toedit = $in{'toedit'};
 $body = $in{'body'};                       ### redid, dumped unneeded textwrap subroutine
	@msglines = split(/\n/,$body);

	open(DATA,">$forumdir/messages/$toedit.txt");
	foreach $msgline (@msglines) {
		if ($msgline !~ /<\/msg>/) {chop($msgline);}
		print DATA "$msgline\n";
	}
	close(DATA);

	for ($i=0; $i<@msglines; $i++) {
		if ($msglines[$i] =~ /<subject>(.*)<\/subject>/) {
			$subject = $1;
		}
		if ($msglines[$i] =~ /<name>(.*)<\/name>/) {
			$name = $1;
		}
		if ($msglines[$i] =~ /<date>(.*)<\/date>/) {
			$date = $1;
			last;
		}
	}
 $replies = -1;
	for ($i=0; $i<@msglines; $i++) {
		if ($msglines[$i] =~ /<msg>/) {
			$replies += 1;
   $replytime
		}
	}
	open(HEADER,"$forumdir/$headerfile.txt");
	@headers = <HEADER>;
	close(HEADER);
	open(HEADER,">$forumdir/$headerfile.txt");
foreach $headerline (@headers) {
@headerdata = split(/_/, $headerline);
		$threadnum = $headerdata[0];
		if ($threadnum == $toedit) {
			@headerdata = split(/_/, $headerline);
	print HEADER "$toedit\_$subject\_$name\_$image\_$postm\_$date\_0\_&nbsp;\n";
}
		else {print HEADER "$headerline";}
}
	close(HEADER);

	print <<"EOF";
<tr><td><table cellpadding="10" cellspacing="1" border="0" width="410" class="border"><tr><td colspan="0" bgcolor="white"><BR><table width="410" border="0" cellspacing="1" cellpadding="0" bordercolor="white"><table width="410" align="center" border="0" cellspacing="0" cellpadding="0"><span class="header"><B>Editing/Deleting Entries</B> | <A HREF="weblog.cgi"><B>Successful</b></A></span><center><BR><BR></B>
	<P><font color="#333">Message number $toedit has been saved<BR><BR>
	<TABLE BORDER="0" CELLSPACING="1" CELLPADDING="1"><TR>
	<FORM NAME="forum" ACTION="weblog-admin.cgi" METHOD="POST">
	<INPUT TYPE="HIDDEN" NAME="username" VALUE="$in{username}">
	<INPUT TYPE="HIDDEN" NAME="password" VALUE="$in{password}">
	<INPUT TYPE="HIDDEN" NAME="command" VALUE="displayList">
	<TD><INPUT TYPE="Submit" class="submit" VALUE="Choose Different Month"></TD>
	</FORM>
	<FORM NAME="forum" ACTION="weblog-admin.cgi" METHOD="POST">
	<INPUT TYPE="HIDDEN" NAME="username" VALUE="$in{username}">
	<INPUT TYPE="HIDDEN" NAME="password" VALUE="$in{password}">
	<INPUT TYPE="HIDDEN" NAME="headerfile" VALUE="$headerfile">
	<INPUT TYPE="HIDDEN" NAME="command" VALUE="displayThreads">
	<TD><INPUT TYPE="Submit" class="submit" VALUE="Edit This Month Again"></TD>
	</FORM>
	</TR></TABLE>
	<FORM>
	<INPUT TYPE="BUTTON" class="submit" VALUE="View Weblog" onClick="document.location.href='weblog.cgi'">
	</FORM>
EOF
	&printFooter;
}

##########################################################################
# deletes the messages that were selected in the &displayThreads page
sub deleteThreads {
	&checkAccess;
	&printHeader("");
	$headerfile = $in{'headerfile'};
	$todelete = $in{'todelete'};
	@threads = split (/,/, $todelete);
	
	open(HEADER,"$forumdir/$headerfile.txt");
	@headerlines = <HEADER>;
	close(HEADER);

	open(HEADER,">$forumdir/$headerfile.txt");
	for ($i=0; $i<@headerlines; $i++) {
		$remove = "false";
		for ($j=0; $j<@threads; $j++) {
			if ($headerlines[$i] =~ /$threads[$j]_/) {
				$remove = "true";
			}
		}
		if ($remove eq "false") {print HEADER "$headerlines[$i]";}
	}
	close(HEADER);
	
	foreach $thread (@threads) {
		unlink ("$forumdir/messages/$thread.txt");
	}

	print "<tr><td><table cellpadding=\"10\" cellspacing=\"1\" border=\"0\" width=\"450\" class=\"border\"><tr><td colspan=\"0\" bgcolor=\"white\"><BR><table width=\"450\" border=\"0\" cellspacing=\"1\" cellpadding=\"0\" bordercolor=\"white\"><table width=\"450\" align=\"center\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\"><span class=\"header\"><B>Deleting Entries</B> | <A HREF=\"weblog.cgi\"><B>Successful</b></A></span><center><BR><BR></B><P><font color=\"#333333\">The following threads were removed:<BR>";
	foreach $thread (@threads) {
		print "$thread,";
	}
	print <<"EOF";

	<BR><BR><TABLE BORDER="0" CELLSPACING="1" CELLPADDING="1"><TR>
	<FORM NAME="forum" ACTION="weblog-admin.cgi" METHOD="POST">
	<INPUT TYPE="HIDDEN" NAME="username" VALUE="$in{username}">
	<INPUT TYPE="HIDDEN" NAME="password" VALUE="$in{password}">
	<INPUT TYPE="HIDDEN" NAME="command" VALUE="displayList">
	<TD><INPUT TYPE="Submit" class="submit" VALUE="Choose Different Month"></TD>
	</FORM>
	<FORM NAME="forum" ACTION="weblog-admin.cgi" METHOD="POST">
	<INPUT TYPE="HIDDEN" NAME="username" VALUE="$in{username}">
	<INPUT TYPE="HIDDEN" NAME="password" VALUE="$in{password}">
	<INPUT TYPE="HIDDEN" NAME="headerfile" VALUE="$headerfile">
	<INPUT TYPE="HIDDEN" NAME="command" VALUE="displayThreads">
	<TD><INPUT TYPE="Submit" class="submit" VALUE="Edit This Month Again"></TD>
	</FORM>
	</TR></TABLE>
	<FORM>
	<INPUT TYPE="BUTTON" class="submit" VALUE="View weblog" onClick="document.location.href='weblog.cgi'">
	</FORM>
EOF
	&printFooter;
}

##########################################################################
# common HTML header for all pages
sub printHeader {
	my($title) = @_;
print "Content-type: text/html\n\n";
	print <<"EOF";
<HTML>
<HEAD>
<TITLE>PerlBlog Admin</TITLE>
<style>
body { background-color:$bgcolor; font-family:Verdana; font-color:#3333333; }
TABLE, TR, TD {  font-family:Verdana; font-color:#333; font-size:8.5pt;}
table.border { background-color: $jcolor; color:#EEEEEE; border-top: $bordercolor 1px solid; border-left: $bordercolor 1px solid; border-right: $bordercolor 1px solid; border-bottom: $bordercolor 1px solid }
table.border2 { background-color: $headercolor; color:#005599; border-top: #DDDDDD 1px solid; border-left: #DDDDDD 1px solid; border-right: #DDDDDD 1px solid; border-bottom: #DDDDDD 1px solid}
.header { font-family:Georgia; color: #4b4b4b; font-size: 13px }
.header  a:link, .header  a:visited, .header  a:active { text-decoration: none; color: #4b4b4b }
.header a:hover { text-decoration: none }
.headerss { font-family:Verdana; color: #4b4b4b; font-size: 11px }
.headerss  a:link, .headerss  a:visited, .headerss  a:active { text-decoration: none; color: #aaaaaa; }
.headerss a:hover { text-decoration: none; }
.jheader { color: $headertxt; font-size: 9pt }
.jheader  a:link, .header  a:visited, .header  a:active { text-decoration: none; color: #4b4b4b }
.jheader a:hover { text-decoration: none }
.textss { font-family:Verdana; font-color:#333333; font-size: 8pt}
.textss  a:link, .text  a:visited, .text  a:active { font-family:Verdana; font-color:#333333; font-size: 8pt }
.textss  a:hover { text-decoration: underline;}
.title { font-family: $titlefont; color: $titlecolor; color; font-size: 14pt}
.title  a:link, .title  a:visited, .title  a:active { text-decoration: none; color: $titlecolor }
.title  a:hover { text-decoration: none; font-color: #005599;}
.subtitle { font-family: Arial; color: #FFFFFF; font-size: 7pt}
.subtitle  a:link, .textt  a:visited, .textt  a:active { text-decoration: none; color: #aaa }
.subtitle  a:hover { text-decoration: underline;}
.small { color: #005599; font-size: 7pt}
.small  a:link, .small  a:visited, .small a:active { text-decoration: none; color: #aaa }
.small  a:hover { font-color: #FFFFFF; text-decoration: none }
input.txt { border: 1px $input solid; padding: 1px; font: 11px Verdana; color: #333; }
textarea.txt { border: 1px #aaa solid; padding: 1px; font: 11px Verdana; color: #aaa; }
input.submit { font-family:Verdana; font-size:11px; background-color: #ffffff; color:#333; border-top: #333 1px solid; border-left: #333 1px solid; border-right: #333 1px solid; border-bottom: #333 1px solid }
td {font-family:verdana;}
</style>

</HEAD><noscript>
<BODY></noscript>
<table cellpadding=0 cellspacing='1' border='0' width='90%' align='center'><tr><td width="0%" vAlign=top>
<P>
<table cellpadding=0 cellspacing='1' border='0' width='90%' align='center'><tr><td width="0%" vAlign=top>
<P><BR><BR>
<BR><table border="0" cellspacing="0" cellpadding="0" align="center" width="410" height="45">
EOF
# Call header file
	open HEADER, "$header"
         or die "Can't open header file because $!\n";
     print while (<HEADER>);
	close HEADER;

print "<span class=ftitle>$title</span>\n";
print "<P>\n";
}
##########################################################################
# common HTML footer for all pages
 sub printFooter {
	open FOOTER, "$forumdir/footer.txt"
         or die "Can't open footer file because $!\n";
     print while (<FOOTER>);
	close FOOTER;
}
	print "\n<br></body></html>\n\n";

