#!/usr/bin/perl
### Best with Perl 5.6 or better
##########################################################################
#  Forum2 Development Overview
#  DForum 1.01 (11/02/1999)
#  http://www.dansteinman.com/dforum
#  Copyright (C) 1998 Dan Steinman
#
#  This version by Ted Hawkins, Forum2.6, January 2003
#  http://scriptles.bluwall.com
#   Including
#   1) Footer script by Michael Mathews, August 2002
#      http://perlcircus.com
#
#   2) Latest reply to a subject posting
#      by Jeff Thomas, December 2002
#      http://www.jhthomas.net
#      Jeff redid the Original Dforum1 this way at www.roigi.com
#      and it has been written into Forum2 as of Version 2.5
#
#   3) PerlBlog v1.08b by Rio Akasaka, May 2003-May 2005
#      Altered Forum2.6 into a customizable and flexible 
#      weblog.
#
#      http://www.chronicled.org/perlblog
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  any later version.
#  
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License (license.txt) for more details.
#  
##########################################################################
#
# Forum Administration Script
# filename:     weblog-admin.pl
# description:  Deletes or edits the messages in the forum
#
##########################################################################
require 'weblog-config.pl';
$header = "$forumdir/header.txt";
##########################################################################

################      NO EDITING NEEDED BELOW HERE     ###################
##########################################################################
#

##########################################################################
# parse form values
read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
@pairs = split(/&/, $buffer);
foreach $pair (@pairs) {
	local($name, $value) = split(/=/, $pair);
	$value =~ tr/+/ /;
	$value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
	$value =~ s/<!--(.|\n)*-->//g;
	$in{$name} = $value;
}

##########################################################################
# miscellaneous values
$command = $in{'command'};
@months = ("January","February","March","April","May","June","July","August","September","October","November","December");

##########################################################################
# determine what sub-routine to run based on the $command form value
if ($command eq '') {&login;}
elsif ($command eq 'displayList') {&displayList;}
elsif ($command eq 'displayThreads') {&displayThreads;}
elsif ($command eq 'deleteThreads') {&deleteThreads;}
elsif ($command eq 'displayEditThread') {&displayEditThread;}
elsif ($command eq 'editThread') {&editThread;}

##########################################################################
# prints the login page
sub login {
	&printHeader("$forumclass");
	print <<"EOF";
<tr><td><table cellpadding="10" cellspacing="1" border="0" width="410" class="border"><tr><td colspan="0" bgcolor="white"><br><table width="410" border="0" cellspacing="1" cellpadding="0" bordercolor="white"><table width="410" align="center" border="0" cellspacing="0" cellpadding="0"><h2>Weblog Administrator - Please Login</h2> </span><BR><BR>
	<FORM ACTION="weblog-admin.pl" METHOD="POST">
	<INPUT TYPE="Hidden" NAME="command" VALUE="displayList">
	<TABLE BORDER=0 CELLSPACING=1 CELLPADDING=1>
	<TR><TD BGCOLOR="#FFFFFF" CLASS="txt">Username:</TD>
 <TD BGCOLOR="#FFFFFF"><INPUT TYPE="Text" CLASS="txt" NAME="username" SIZE="25"></TD></TR>
	<TR><TD BGCOLOR="#FFFFFF" CLASS="txt">Password:</TD>
 <TD BGCOLOR="#FFFFFF"><INPUT TYPE="Password" CLASS="txt" NAME="password" SIZE="25"></TD></TR>
	<TR><TD BGCOLOR="#FFFFFF" CLASS="headers"><BR>
											<BR>
										</TD>
										<td><INPUT TYPE="Submit" CLASS="submit" VALUE="Login"></td>
									</TR>
	</TABLE>
	</FORM><BR>Return to your weblog by clicking <A HREF="weblog.pl">here</A><br>----------------------------------------------------------------------------------<BR><small>Powered by PerlBlog</small><br><br></tr></table></td></tr></td></tr></table></div>
EOF
	&printSooter;
}

##########################################################################
# checks username and password, called from every sub-routine
sub checkAccess {
	if ($in{'username'} ne $adminusername || $in{'password'} ne $adminpassword) {
		print "Content-type: text/html\n\n";
		print "Access Denied - Click Back to Retry Your Login and Password.";
		exit(0);
	}
}
##########################################################################
# prints a list of months that have been archived
sub displayList {
	&checkAccess;
	&printHeader("");
	print "<FORM ACTION=\"weblog-admin.pl\" METHOD=\"POST\">\n";
	open(MONTHS,"$forumdir/months.txt");
	@headerfiles = <MONTHS>;
	close(MONTHS);
	print <<"EOF";
<tr><td><table cellpadding="10" cellspacing="1" border="0" width="410" class="border"><tr><td colspan="0" bgcolor="white"><BR><table width="410" border="0" cellspacing="1" cellpadding="0" bordercolor="white"><table width="410" align="center" border="0" cellspacing="0" cellpadding="0"><h2>Choose Month to Edit</h2> </span><p>&nbsp;</p>
	<TABLE BORDER=0 CELLSPACING=1 CELLPADDING=1>
	<TR BGCOLOR="#FFFFFF"><TD CLASS="headers">Month</TD><TD CLASS="headers">Year</TD></TR>
EOF
	foreach $headerfile (@headerfiles) {
		if ($headerfile ne '') {
			$year = substr ($headerfile,0,4);
			$month = substr ($headerfile,4,5);
			$month = sprintf("%5.0f", $month);
			$monthname = $months[$month-1];
			$headerfile = substr ($headerfile,0,6);
			print "<TR BGCOLOR=\"#FFFFFF\"><TD><INPUT TYPE=\"Radio\" NAME=\"headerfile\" VALUE=\"$headerfile\">$monthname&nbsp;&nbsp;</TD><TD>$year</TD></TR>\n";
		}
	}
	print <<"EOF";
	<INPUT TYPE="Hidden" NAME="username" VALUE="$in{username}">
	<INPUT TYPE="Hidden" NAME="password" VALUE="$in{password}">
	<INPUT TYPE="Hidden" NAME="command" VALUE="displayThreads">
	<TR BGCOLOR="#FFFFFF"><TD><BR><BR><INPUT TYPE="Submit" class="submit" VALUE="Edit Month"></TD></TR>
	</TABLE>
	</FORM><br><BR><small>Powered by PerlBlog</small><br><br></tr></table></td></tr></td></tr></table></div>
EOF
	&printSooter;
}

##########################################################################
# print the headers for a particular month
sub displayThreads {
	&checkAccess;
	$headerfile = $in{'headerfile'};

	$year = substr ($headerfile,0,4);
	$month = substr ($headerfile,4,5);
	$month = sprintf("%5.0f", $month);
	$monthname = $months[$month-1];
	
	open(DATA,"$forumdir/$headerfile.txt");
	@headerlines = <DATA>;
	close(DATA);
	$length = @headerlines;

	&printHeader("");
	print <<"EOF";
	<SCRIPT LANGUAGE="JavaScript">
	<!--
	
	function submitForm(which) {
		df = document.forum
		if (which == 'delete') {
			var str = ""
			for (var i=0; i<$length; i++) {
				if (eval('df.delete'+i+'.checked == true')) {
					str += eval('df.delete'+i+'.value')+","
				}
			}
			if (str!="") {
				df.todelete.value = str.substring(0,str.length-1)
				df.command.value = "deleteThreads"
				df.submit()
			}
			else {
				df.todelete.value = str.substring(0,str.length-1)
				df.command.value = "deleteThreads"
				df.submit()
			}
		}
		else if (which == 'edit') {
			var editselected = false
			for (var i=0; i<df.toedit.length; i++) {
				if (df.toedit[i].checked == true) {
					editselected = true
					break
				}
			}
			if (editselected == false) {
				df.command.value = "displayEditThread"
				df.submit()
			}
			else {
				df.command.value = "displayEditThread"
				df.submit()
			}
		}
	}
	
	//-->
	</SCRIPT>

<tr><td><table cellpadding="10" cellspacing="1" border="0" width="410" class="border"><tr><td colspan="0" bgcolor="white"><BR><table width="410" border="0" cellspacing="1" cellpadding="0" bordercolor="white"><table width="410" align="center" border="0" cellspacing="0" cellpadding="0"><h2>Editing/Deleting Entries | <A HREF="weblog.pl"><B>$monthname $year</b></a></h2><BR><BR>
	<TABLE BORDER=0 width="650" CELLSPACING=1 CELLPADDING=1>
	<TR BGCOLOR="#FFFFFF"><TD class="border">&nbsp;Delete</TD><TD class="border">&nbsp;Edit</TD><TD class="border">&nbsp;Subject</TD><TD class="border">&nbsp;Entry</TD><TD CLASS="headers">Responses</TD>
	<FORM NAME="forum" ACTION="weblog-admin.pl" METHOD="POST">
EOF
	for ($i=0;$i<@headerlines;$i++) {
		if ($headerlines[$i] ne '') {
			@info = split (/_/, $headerlines[$i]);
			$num = $info[0];
			$subject = $info[1];
			$name = $info[2];
			$date = $info[3];
			$responses = $info[6];
			print <<"EOF";
			<TR BGCOLOR="#FFFFFF"><TD ALIGN="CENTER"><INPUT TYPE="Checkbox" NAME="delete$i" VALUE="$num"></TD>
			<TD ALIGN="CENTER"><INPUT TYPE="Radio" NAME="toedit" VALUE="$num"></TD>
			<TD>&nbsp;$subject&nbsp;</TD><TD>&nbsp;$name&nbsp;</TD><TD ALIGN="CENTER">$responses</TD></TR>
EOF
		}
	}
	print <<"EOF";
	<TR BGCOLOR="#FFFFFF">
	<TD><BR><BR><INPUT TYPE="BUTTON" class="submit" VALUE="Delete" onClick="submitForm('delete')"></TD>
	<TD><BR><BR><INPUT TYPE="BUTTON" class="submit" VALUE="Edit" onClick="submitForm('edit')"></TD>
	</TR>
	</TABLE>
	<INPUT TYPE="HIDDEN" NAME="todelete">
	<INPUT TYPE="HIDDEN" NAME="headerfile" VALUE="$headerfile">
	<INPUT TYPE="HIDDEN" NAME="username" VALUE="$in{username}">
	<INPUT TYPE="HIDDEN" NAME="password" VALUE="$in{password}">
	<INPUT TYPE="HIDDEN" NAME="command" VALUE="">
	</FORM><br><BR><small>Powered by PerlBlog</small><br><br></tr></table></td></tr></td></tr></table></div>
EOF
	&printSooter;
}

##########################################################################
# prints the edit thread page, where you edit the source file to a message
sub displayEditThread {
	&checkAccess;
	$headerfile = $in{'headerfile'};
	$toedit = $in{'toedit'};
	$toedit =~ s/[\x00-\x20<>\|;\(\)\$^\+!\^\[\]\?\"\'\`]//g;
	&printHeader("");
	print <<"EOF";
<tr><td><table cellpadding="10" cellspacing="1" border="0" width="410" class="border"><tr><td colspan="0" bgcolor="white"><BR><table width="410" border="0" cellspacing="1" cellpadding="0" bordercolor="white"><table width="410" align="center" border="0" cellspacing="0" cellpadding="0"><h2>Editing/Deleting Entries | <A HREF="weblog.pl">Thread $toedit</A></h2><br><font size="1">Edit within the first  &lt;name&gt; parameters for the actual blog entry<br>Comments follow blog entry</font></span><center><BR><BR></B>
	<FORM NAME="forum" ACTION="weblog-admin.pl" METHOD="POST">
	<TEXTAREA NAME="body" STYLE="overflow:hidden" class="txt" ROWS=20 COLS=65>
EOF
	open(DATA,"$forumdir/messages/$toedit.txt");
	@msglines = <DATA>;
	close(DATA);
	foreach $msgline (@msglines) {
		print $msgline;
	}
	print "</TEXTAREA>\n";
	print <<"EOF";
	<BR>
	<INPUT TYPE="HIDDEN" NAME="toedit" VALUE="$toedit">
	<INPUT TYPE="HIDDEN" NAME="headerfile" VALUE="$headerfile">
	<INPUT TYPE="HIDDEN" NAME="username" VALUE="$in{username}">
	<INPUT TYPE="HIDDEN" NAME="password" VALUE="$in{password}">
	<INPUT TYPE="HIDDEN" NAME="command" VALUE="editThread"><BR><BR>
	<INPUT TYPE="Submit" class="submit" VALUE="Save Entry">
	</FORM><br><BR><small>Powered by PerlBlog</small><br><br></tr></table></td></tr></td></tr></table></div>
EOF
	&printSooter;
}

##########################################################################
# sub-routine of &displayPreview that wraps a block of text to a given line length
# Deleted to see if it affect runing on Linux. Works okay on NTP on PC with Apache
# Not needed for admin

##########################################################################
# saves the message that was being edited
sub editThread {
	&checkAccess;
	&printHeader("");
	$headerfile = $in{'headerfile'};
	$toedit = $in{'toedit'};
    $body = $in{'body'};                       ### redid, dumped unneeded textwrap subroutine
	@msglines = split(/\n/,$body);

	open(DATA,">$forumdir/messages/$toedit.txt");
	foreach $msgline (@msglines) {
		if ($msgline !~ /<\/msg>/) {chop($msgline);}
		print DATA "$msgline\n";
	}
	close(DATA);

	for ($i=0; $i<@msglines; $i++) {
		if ($msglines[$i] =~ /<subject>(.*)<\/subject>/) {
			$subject = $1;
		}
		if ($msglines[$i] =~ /<name>(.*)<\/name>/) {
			$name = $1;
		}
		if ($msglines[$i] =~ /<date>(.*)<\/date>/) {
			$date = $1;
			last;
		}
	}
 $replies = -1;
	for ($i=0; $i<@msglines; $i++) {
		if ($msglines[$i] =~ /<msg>/) {
			$replies += 1;
   $replytime
		}
	}
	open(HEADER,"$forumdir/$headerfile.txt");
	@headers = <HEADER>;
	close(HEADER);
	open(HEADER,">$forumdir/$headerfile.txt");
foreach $headerline (@headers) {
@headerdata = split(/_/, $headerline);
		$threadnum = $headerdata[0];
		if ($threadnum == $toedit) {
			@headerdata = split(/_/, $headerline);
	print HEADER "$toedit\_$subject\_$name\_$image\_$postm\_$date\_0\_&nbsp;\n";
}
		else {print HEADER "$headerline";}
}
	close(HEADER);

	open(ALL,"$forumdir/all.txt");
	@headers = <ALL>;
	close(ALL);
	open(ALL,">$forumdir/all.txt");
foreach $headerline (@headers) {
@headerdata = split(/_/, $headerline);
		$threadnum = $headerdata[0];
		if ($threadnum == $toedit) {
			@headerdata = split(/_/, $headerline);
	print ALL "$toedit\_$subject\_$name\_$image\_$postm\_$date\_0\_&nbsp;\n";
}
		else {print ALL "$headerline";}
}
	close(ALL);
	print <<"EOF";
<tr><td><table cellpadding="10" cellspacing="1" border="0" width="410" class="border"><tr><td colspan="0" bgcolor="white"><BR><table width="410" border="0" cellspacing="1" cellpadding="0" bordercolor="white"><table width="410" align="center" border="0" cellspacing="0" cellpadding="0"><h2>Editing Entries | <A HREF="weblog.pl">Successful</A></h2><BR><BR>
	<P>Message number $toedit has been saved<BR><BR>
	<TABLE BORDER="0" CELLSPACING="1" CELLPADDING="1"><TR>
	<FORM NAME="forum" ACTION="weblog-admin.pl" METHOD="POST">
	<INPUT TYPE="HIDDEN" NAME="username" VALUE="$in{username}">
	<INPUT TYPE="HIDDEN" NAME="password" VALUE="$in{password}">
	<INPUT TYPE="HIDDEN" NAME="command" VALUE="displayList">
	<INPUT TYPE="Submit" class="submit" VALUE="Choose Different Month">
	</FORM><br>
	<FORM NAME="forum" ACTION="weblog-admin.pl" METHOD="POST">
	<INPUT TYPE="HIDDEN" NAME="username" VALUE="$in{username}">
	<INPUT TYPE="HIDDEN" NAME="password" VALUE="$in{password}">
	<INPUT TYPE="HIDDEN" NAME="headerfile" VALUE="$headerfile">
	<INPUT TYPE="HIDDEN" NAME="command" VALUE="displayThreads">
	<INPUT TYPE="Submit" class="submit" VALUE="Edit This Month Again">
	</FORM>
	
	<FORM><br>
	<INPUT TYPE="BUTTON" class="submit" VALUE="View Weblog" onClick="document.location.href='weblog.pl'">
	</FORM><br><BR><small>Powered by PerlBlog</small><br><br></tr></table></td></tr></td></tr></table></div>
EOF
	&printSooter;
}

##########################################################################
# deletes the messages that were selected in the &displayThreads page
sub deleteThreads {
	&checkAccess;
	&printHeader("");
	$headerfile = $in{'headerfile'};
	$todelete = $in{'todelete'};
	@threads = split (/,/, $todelete);
	
	open(HEADER,"$forumdir/$headerfile.txt");
	@headerlines = <HEADER>;
	close(HEADER);

	open(HEADER,">$forumdir/$headerfile.txt");
	for ($i=0; $i<@headerlines; $i++) {
		$remove = "false";
		for ($j=0; $j<@threads; $j++) {
			if ($headerlines[$i] =~ /$threads[$j]_/) {
				$remove = "true";
			}
		}
		if ($remove eq "false") {print HEADER "$headerlines[$i]";}
	}
	close(HEADER);

	open(ALL,"$forumdir/all.txt");
	@headerlines = <ALL>;
	close(ALL);

	open(ALL,">$forumdir/all.txt");
	for ($i=0; $i<@headerlines; $i++) {
		$remove = "false";
		for ($j=0; $j<@threads; $j++) {
			if ($headerlines[$i] =~ /$threads[$j]_/) {
				$remove = "true";
			}
		}
		if ($remove eq "false") {print ALL "$headerlines[$i]";}
	}
	close(ALL);
	
	foreach $thread (@threads) {
		unlink ("$forumdir/messages/$thread.txt");
	}
	print <<"EOF";
	<tr><td><table cellpadding="10" cellspacing="1" border="0" width="410" class="border"><tr><td colspan="0" bgcolor="white"><BR><table width="410" border="0" cellspacing="1" cellpadding="0" bordercolor="white"><table width="410" align="center" border="0" cellspacing="0" cellpadding="0"><h2>Deleting Entries | <A HREF="weblog.pl">Successful</A></h2><BR><BR><P>The following threads were removed:<BR>
EOF
	foreach $thread (@threads) {
		print "$thread,";
	}
	print <<"EOF";
	<BR><BR>
	<TABLE BORDER="0" CELLSPACING="1" CELLPADDING="1"><TR>
	<FORM NAME="forum" ACTION="weblog-admin.pl" METHOD="POST">
	<INPUT TYPE="HIDDEN" NAME="username" VALUE="$in{username}">
	<INPUT TYPE="HIDDEN" NAME="password" VALUE="$in{password}">
	<INPUT TYPE="HIDDEN" NAME="command" VALUE="displayList">
	<INPUT TYPE="Submit" class="submit" VALUE="Choose Different Month">
	</FORM><br>
	<FORM NAME="forum" ACTION="weblog-admin.pl" METHOD="POST">
	<INPUT TYPE="HIDDEN" NAME="username" VALUE="$in{username}">
	<INPUT TYPE="HIDDEN" NAME="password" VALUE="$in{password}">
	<INPUT TYPE="HIDDEN" NAME="headerfile" VALUE="$headerfile">
	<INPUT TYPE="HIDDEN" NAME="command" VALUE="displayThreads">
	<INPUT TYPE="Submit" class="submit" VALUE="Edit This Month Again">
	</FORM><br>
	<FORM>
	<INPUT TYPE="BUTTON" class="submit" VALUE="View weblog" onClick="document.location.href='weblog.pl'">
	</FORM><br><BR><small>Powered by PerlBlog</small><br><br></tr></table></td></tr></td></tr></table></div>
EOF
	&printSooter;
}

##########################################################################
# common HTML header for all pages
sub printHeader {
	my($title) = @_;
print "Content-type: text/html\n\n";
	print <<"EOF";
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">

<html xmlns="http://www.w3.org/1999/xhtml" lang="en" xml:lang="en">
<head>
<TITLE>$blogtitle</TITLE>
<meta name="description" content="$description" />
<meta name="keywords" content="$keywords" />
<meta name="author" content="$author" />
<style>
html { height: 100%; }
* { padding: 0; border: 0; margin: 0; }
body { font-family: $bodyfont; background-color: $bgcolor;font-size:$fontsz; color:$bodycolor;border: 0px; height: 100%; margin: 0px; padding: 0px;letter-spacing: 0px; line-height: 1.5em; }
.body p {font-family:$bodyfont; color:$bodycolor;font-size:$bodyesize }
.body { padding-left:20px;margin-bottom: 2em; margin-top: 1em; } 
.body { text-align:justify; }
.top { width: $width; height:$height; background: $bgtopcolor url($headerimg) no-repeat top center; margin: 0 auto; }
.top p { padding-top:$paddingtp; padding-left:$paddinglft; }
.footer { width: $width; height:$footerheight; background: $footercolor url($footerimg) no-repeat bottom center;  }
.footer p { padding-top:10px; padding-left:$paddinglft; color:$footertxt; font-family:$footerfont; font-size:$footersize;}
.banner { width: $width; background: $maincolor  repeat-y center url($bgimg); margin: 0 auto; }
#areabox {width: $jwidth;  margin-bottom: 60px;padding-top:10px; padding-left:$paddinglft; padding-bottom: 20px; min-height: 400px}
#sidebar { background-color:$sidebarcolor;float: $direction; width: $swidth;padding-top:10px; padding-right:$paddingr; padding-left:$paddingl; }
p a.subtitle:link, p a.subtitle:visited, p a.subtitle:active {font-family:$subttfont;text-decoration: none; color: $subttcolor; font-size:$subtitlesize; text-decoration:$subttdeco; font-weight:$subtitlewg;}
p a.subtitle:hover {font-family:$subtthfont;text-decoration: none; color: $subtthcolor; font-size:$subtitlehsize; text-decoration:$subtthdeco; font-weight:$subtitlehpwg;}
p a.subtitlelink:link, p a.subtitlelink:visited, p a.subtitlelink:active {font-family:$subttfontl;text-decoration: none; color: $subttcolorl; font-size:$subtitlesizel; text-decoration:$subttdecol; font-weight:$subtitlewgl;}
p a.subtitlelink:hover {font-family:$subtthfontl;text-decoration: none; color: $subtthcolorl; font-size:$subtitlehsizel; text-decoration:$subtthdecol; font-weight:$subtitlehpwgl;}
p a.title:link, p a.title:visited, p a.title:active {font-family:$headertitlefont;text-decoration: none; 
color:$headertitlecolor;font-size:$titlesize;font-weight:$headertitlewg;border-bottom: none;}
h2, .h2 {font-family: $titlefont; font-size: $tentrysize; line-height: normal; padding-bottom:0.3em;font-weight: bold; color: $titlecolor;}
.comments {font-family:$bodyfont;border-bottom-color: $bodycolor; border-bottom-style: dotted; border-bottom-width: 1px; padding-bottom: 3px; margin-top: 3px; margin-bottom: 10px; border-color: $bodycolor; } 
.section { font-family: $sectionfont; font-size: $sectionsize; text-align: left; line-height: 1.4em; margin-bottom: 22px; color: $sectionclr; }
.tag {font-family:$tagfont; font-weight:$tagweight; color:$tagcolor; font-size:$tagfontsize;}
a:link, a:visited, a:active { text-decoration: $linkdeco; color: $linkcolor;font-weight:$linkweight; }
a:hover{ text-decoration: $txtdecohover; color:$hover; font-weight:$fntweight; }
img { border: none; }
p img { padding:$imgpadding; border:1px solid $imgborder; background-color:$imgback; }
p { margin: 0 0 12px 0; padding: 0; }
textarea { width: 380px; overflow:hidden; scrollbar:none; }
input.txt { background-color:$inputbg; border: 1px $inputborder solid; padding: 1px; font: $inputfsize $inputfont; color: $inputcolor; }
textarea.entrytext { background-color:$inputbg;overflow: hidden; border: 1px $inputborder solid; padding: 1px; font: $inputfsize $inputfont; color: $inputcolor; }
input.submit { font-family:$submitfont; font-size:$submitfontsize; background-color: $submitbg; color:$submitfontcolor; border-top: $submitborder 1px solid; border-left:$submitborder 1px solid; border-right: $submitborder 1px solid; border-bottom: $submitborder 1px solid; }
.section .caption {border-bottom-color: $bodycolor; border-bottom-style: dotted; border-bottom-width: 1px; font-weight: $sidefweight; font-size: $sectionfsize; font-family: $sectiontfont; padding-bottom: 3px; margin-top: 3px; margin-bottom: 10px; color: $sidefcolor; border-color: $bodycolor; }
.section p { margin: 0 0 10px 0; padding: 0; line-height:1.4em; }
.section a:link, .section a:visited, .section a:active { font-family:$sectionlfont; color: $sectionlc; size: $sectionls; font-weight:$sectionlwg; text-decoration:$sectiondecol;}
.section a:hover { font-family:$sectionlfonth; color: $sectionlch; size: $sectionlsh; font-weight:$sectionlwgh;text-decoration:$sectiondecolh;}
.description p { margin: 0 0 10px 0; padding: 0; line-height:1.4em; text-align:justify; }
input.ed_button {margin-right:3px; margin-bottom:3px; background-color:#ffffff; border: 1px #4b4b4b solid; padding: 1px; font: 11px Georgia; color: #333333; }
table, td {padding-left:20px; text-align:justify; padding-right:20px;}
</style>
</HEAD>
<BODY>
<table cellpadding=0 cellspacing='1' border='0' width='90%' align='center'><tr><td width="0%" vAlign=top>
<P>
<table cellpadding=0 cellspacing='1' border='0' width='90%' align='center'><tr><td width="0%" vAlign=top>
<P><BR><BR>
<BR><table border="0" cellspacing="0" cellpadding="0" align="center" width="410" height="45">
EOF
print "<span class=ftitle>$title</span>\n";
print "<P>\n";
}
##########################################################################
# common HTML footer for all pages
 sub printFooter {
	open FOOTER, "$forumdir/footer.txt"
         or die "Can't open footer file because $!\n";
     print while (<FOOTER>);
	close FOOTER;
}
	print "\n<br></body></html>\n\n";

