#!/usr/bin/perl
### Best with Perl 5.6 or better
#  Path to Perl - you may need to check your server admin just in case
#  it is different.
##########################################################################
#  Weblog Script Based on:
#  DForum 1.01 (11/02/1999)
#  http://www.dansteinman.com/dforum
#  Copyright (C) 1998 Dan Steinman
#
#  This version by Ted Hawkins, Forum2.6, January 2003
#  http://scriptles.bluwall.com
#   Including
#   1) Footer script by Michael Mathews, August 2002
#      http://perlcircus.com
#
#   2) Latest reply to a subject posting
#      by Jeff Thomas, December 2002
#      http://www.jhthomas.net
#      Jeff redid the Original Dforum1 this way at www.roigi.com
#      and it has been written into Forum2 as of Version 2.5
#   
#   3) PerlBlog v1.08b by Rio Akasaka, May 2003-May 2005
#      Altered Forum2.6 into a customizable and flexible 
#      weblog.
#
#      http://www.chronicled.org/perlblog
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  any later version.
#  
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License (license.txt) for more details.
#  
########################################################################
require 'weblog-config.pl';
$header = "$forumdir/header.txt";
$numnths = "2";
read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
@pairs = split(/&/, $buffer);
foreach $pair (@pairs) {
    local($name, $value) = split(/=/, $pair);
    $value =~ tr/+/ /;
    $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
    $value =~ s/<!--(.|\n)*-->//g;
    $in{$name} = $value;
}
######################## TIMES AND DATES ########################
$bigwidth = ($width + 43);
($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime(time);
$year = 1900 + $year;
$lastyear = ($year - 1);                                          #JHT added lastyear
$dec = "12";                                                      # Use for December at year change
$lastmonth = $mon;
$cowidth = ($cwidth - 40);
$bigwidth = ($width + 22);
$today= $mday;
$yesterday= ($mday - 1);
$thismonth = ($mon + 1);
if ($lastmonth <10) {$lastmonth = "0$lastmonth";}
if ($thismonth <10) {$thismonth = "0$thismonth";}
if ($mday <10) {$mday = "0$mday";}
if ($hour<10) {$hour = "0$hour";}
if ($min<10) {$min = "0$min";}
$todaysdate = "$thismonth/$mday/$year-$hour:$min";
$todaysday = "$mday";
$newheaderfile = "$year$thismonth";
@months = ("January","February","March","April","May","June","July","August","September","October","November","December");
######################## QUERIES FOR SUB-ROUTINE ########################
if ($ENV{'QUERY_STRING'} ne '') {
    @qstr = split (/=/,$ENV{'QUERY_STRING'});
    $command = $qstr[0];
    $value = $qstr[1];
    $value =~ s/[\x00-\x20<>\|;\(\)\$^\+!\^\[\]\?\"\'\`]//g;
    
    if ($command eq "archives") {&displayArchives;}
    elsif ($command eq "month") {&displayMonth ($value);}
    elsif ($command eq "about") {&displayAbout;}
    elsif ($command eq "msg") {&displayMessage ($value);}
    elsif ($command eq "$code") {&displaySubmit;}
    elsif ($command eq "popreview") {&displayPopPreview;}
    elsif ($command eq "trackback") {&displayDisplay ($value);}
    elsif ($command eq "reply") {&displayReply ($value);}
    elsif ($command eq "popup") {&displayPopupreply ($value);}
    elsif ($command eq "preview") {&displayPreview;}
    else {&displayDefault;}
}
else {
    # if no query string check for a 'post' form value (needed when posting a new thread or reply)
    if ($in{'post'}) {&postMessage;}
    # print the default page
    else {&displayDefault;}
}
######################## DEFAULT HTML PAGE ########################
sub displayDefault {
    &printHeader("");
    print <<"EOF";
<br />
EOF
    &printSidemenu;
    print <<"EOF";
<div class="sectionWrapper"><div class="section">
   <div class="caption">Recent Posts</div> 
EOF
    &printRecentPosts;
    print <<"EOF";
</noscript></div></div></div></div>
<div id="areabox">
EOF
    &printMonthLines ("$year$thismonth"); # this shows the weblog entries for this month                    
    print <<"EOF";
</div>
EOF
    &printFooter;
             }
######################## MY ABOUT PAGE ########################
sub displayAbout {
    &printHeader("");
    print <<"EOF";
<br />
EOF
    &printSidemenu;
    print <<"EOF";
</div></div>
<div id="areabox"><div class="post">    
EOF
    &printAboutPage;
    print <<"EOF";
    </p></div></div>
EOF
    &printFooter;
}
######################## ARCHIVES PAGE WITH MONTHS ########################
sub displayArchives {
    open (MONTHS,"$forumdir/months.txt");
    @monthlines = <MONTHS>;
    close (MONTHS);
    &printHeader("");
    print <<"EOF";
<br />
EOF
    &printSidemenu;
    print <<"EOF";
</div></div>
<div id="areabox"><div class="post"><h2>Archives</h2><div class="body"><p>
EOF
    foreach $headerfile (@monthlines) {
        if ($headerfile ne '') {
            $year = substr ($headerfile,0,4);
            $month = substr ($headerfile,4,6);
            $month = sprintf("%5.0f", $month);
            $monthname = $months[$month-1];
    print <<"EOF";
<A CLASS="items" HREF="weblog.pl?month=$headerfile">$monthname</span></a> &nbsp;&nbsp;<A CLASS="items" HREF="weblog.pl?month=$headerfile">$year</a></span><br />
EOF
        }
    } 
    print <<"EOF";
    </p></div></div></div>
EOF
    &printFooter;
}
######################## DISPLAYS A SPECIFIC MONTH UNDER ARCHIVES ########################
sub displayMonth {
    my($headerfile) = @_;
    $year = substr ($headerfile,0,4);
    $month = substr ($headerfile,4,6);
    $month = sprintf("%5.0f", $month);
    $monthname = $months[$month-1];
    &printHeader("");
    print <<"EOF";
    <br />
EOF
    &printSidemenu;
    print <<"EOF";
</div></div>
<div id="areabox"><div class="post"><h2>Archives for $monthname $year</h2><p>
EOF
 &printAllMonthLines ($headerfile);
    print <<"EOF";
</p></div></div>
EOF
    &printFooter;
}
######################## SHOWS YOUR ENTRIES (GENERAL SETTINGS 1) ########################
sub printNumLines {
 open(DATA,"$forumdir/num.txt");
    @numlines = <DATA>;
    close(DATA);
    for ($i=0; $i<@msglines; $i++) {
        if ($msglines[$i] =~ /<msg>/) {push (@msgstart, $i);}
        elsif ($msglines[$i] =~ /<\/msg>/) {push (@msgend, $i);}
    }
    for ($i=0; $i<@msgstart; $i++) {
        for ($j=$msgstart[$i]; $j<$msgend[$i]; $j++) {
            if ($msglines[$j] =~ /<name>(.*)<\/name>/) {
                $name = $1;
                if ($i != 0) {
                    print "<div class=\"comments\"><p>Posted by: $name\n";
                }
                else {print "$subject $name";}
                print "";
            }
            elsif ($msglines[$j] =~ /<email>(.*)<\/email>/) {
                $email = $1;
                if ($email) {print " from <A HREF=\"$email\">$email</A>";}
            }
    elsif ($msglines[$j] =~ /<website>(.*)<\/website>/) {
                $website = $1;
                if ($website) {print " (#$website)";}
            }
            elsif ($msglines[$j] =~ /<date>(.*)<\/date>/) {
                $date = $1;
                print "\n";
            }
            elsif ($msglines[$j] =~ /<body>/) {
                print "</p><p>\n";
        for ($k=$j+1; $k<@msglines; $k++) {
                    if ($msglines[$k] =~ /<\/body>/) {
                        print "";
                        last;
                    }
                    else {print "$msglines[$k]";}
                    $j++;
                }
            }
        }
    }
}
######################## RECENT POSTS ########################
sub printRecentPosts {
    my($filename) = @_;
    if (open(DATA,"$forumdir/all.txt")) {
        @msglines = <DATA>;
        close(DATA);
        foreach $msgline (@msglines) {
            if ($msgline ne '') {
                @info = split (/_/, $msgline);
                $num = $info[0];
                $subject = $info[1];
                $name = $info[2];   
                $image = $info[3];  
                $postm = $info[4]; 
                $date = $info[5];       
                $date2 = $date =~ m/(.*)-(.*)/gi;
                $date_date = $1;
                $date_time = $2;     
                $responses = ($info[6]);                  
                $year = substr ($headerfile,0,4);
                $month = substr ($headerfile,4,6);
                $month = sprintf("%5.0f", $month);
                $monthname = $months[$month-1];
                $recenum = $num;
                $showcomment = ($recentnum - 1);
    open(NUM,"$forumdir/num.txt");
    $num = <NUM>;
    close(NUM);
    $tums= ($num - $showcomment);
            if ($recenum <$tums) {
             print "<noscript>"; }
            else {print "";}
     if ($popup eq "no") {
        print "<a href=\"?reply=$recenum\">$subject</a><br />";
    }
    if ($popup eq "yes") {
        print "<script src=\"$ssource/openwin.js\" type=\"text/javascript\"></script><a href=\"javascript:launchWin('?popup=$recenum','Comments',$cheight,$cwidth,0,0,1);\">$subject</a><br />";
    }
         if ($postnum <$ums) {
             print "</noscript>"; }
            else {print "";}
            }
        }
    }
}

######################## SHOWS YOUR ENTRIES (GENERAL SETTINGS 2) ########################
sub printMonthLines {
    my($filename) = @_;
    if (open(DATA,"$forumdir/all.txt")) {
        @msglines = <DATA>;
        close(DATA);
        foreach $msgline (@msglines) {
            if ($msgline ne '') {
                @info = split (/_/, $msgline);
                $num = $info[0];
                $subject = $info[1];
                $name = $info[2];   
                $image = $info[3];  
                $postm = $info[4]; 
                $date = $info[5];       
                $date2 = $date =~ m/(.*)-(.*)/gi;
                $date_date = $1;
                $date_time = $2;     
                $responses = ($info[6]);                  
                $year = substr ($headerfile,0,4);
                $month = substr ($headerfile,4,6);
                $month = sprintf("%5.0f", $month);
                $monthname = $months[$month-1];
                $postnum = $num;
                $showposts = ($show - 1);
    open(NUM,"$forumdir/num.txt");
    $num = <NUM>;
    close(NUM);
    $ums= ($num - $showposts);
            if ($postnum <$ums) {
             print "<noscript>"; }
            else {print "";}
          print <<"EOF";
<div class="post"><h2>$subject</h2><div class="body"><p>$name</p></div><div class="tag">$posted<i>$date_date - $date_time - </i> <img src="$ssource/comments.gif" width="11" height="10" alt="Post your comment!" />
EOF
     if ($popup eq "no") {
        print "<a href=\"?reply=$postnum\" title=\"Post a comment\">$responses comments</a>";
    }
    if ($popup eq "yes") {
        print "<script src=\"$ssource/openwin.js\" type=\"text/javascript\"></script><a href=\"javascript:launchWin('?popup=$postnum','Comments',$cheight,$cwidth,0,0,1);\" title=\"Post a comment\">$responses comments</a>";
    }
print <<"EOF";
 |  <a href="?trackback=$postnum">Permalink</a></div></div><p>&nbsp;</p><p>&nbsp;</p>
EOF
         if ($postnum <$ums) {
             print "</noscript>"; }
            else {print "</noscript>";}
            }
        }
    }
}

######################## SHOWS YOUR ALL ENTRIES FOR A SPECIFIC MONTH ########################
sub printAllMonthLines {
    my($filename) = @_;
    if (open(DATA,"$forumdir/$filename.txt")) {
        @msglines = <DATA>;
        close(DATA);
        foreach $msgline (@msglines) {
            if ($msgline ne '') {
                @info = split (/_/, $msgline);
                $num = $info[0];
                $subject = $info[1];
                $name = $info[2];   
                $image = $info[3];  
                $postm = $info[4]; 
                $date = $info[5];  
                $date2 = $date =~ m/(.*)-(.*)/gi;
                $date_date = $1;
                $date_time = $2;
                $responses = ($info[6]);                  
                $year = substr ($headerfile,0,4);
                $month = substr ($headerfile,4,6);
                $month = sprintf("%5.0f", $month);
                $monthname = $months[$month-1];
                $postnum = $num;
          print <<"EOF";
<div class="post"><h2>$subject</h2><div class="body"><p>$name</p></div><div class="tag">$posted<i>$date_date - $date_time - </i> <img src="$ssource/comments.gif" width="11" height="10" alt="Post your comment!" />
EOF
     if ($popup eq "no") {
        print "<a href=\"?reply=$postnum\" title=\"Post a comment\">$responses comments</a>";
    }
    if ($popup eq "yes") {
        print "<script src=\"$ssource/openwin.js\" type=\"text/javascript\"></script><a href=\"javascript:launchWin('?popup=$postnum','Comments',$cheight,$cwidth,0,0,1);\" title=\"Post a comment\">$responses comments</a>";
    }
print <<"EOF";
 |  <a href="?trackback=$postnum">Permalink</a></div></div><p>&nbsp;</p>
EOF

            }
        }
    }
}
######################## COMMENT BOX/REPLY SETTINGS ########################
sub parseMessageData {
    my($filename) = @_;
    my($msgstart, $msgend, @msglines);
    open(DATA,"$forumdir/messages/$filename.txt");
    @msglines = <DATA>;
    close(DATA);
    for ($i=0; $i<@msglines; $i++) {
        if ($msglines[$i] =~ /<msg>/) {push (@msgstart, $i);}
        elsif ($msglines[$i] =~ /<\/msg>/) {push (@msgend, $i);}
    }
    for ($i=0; $i<@msgstart; $i++) {
        for ($j=$msgstart[$i]; $j<$msgend[$i]; $j++) {
            if ($msglines[$j] =~ /<name>(.*)<\/name>/) {
                $name = $1;
                if ($i != 0) {
                    print "<div class=\"comments\"><p>$name\n";
                }
                else {print "$name";}
                print "";
            }
            elsif ($msglines[$j] =~ /<email>(.*)<\/email>/) {
                $email = $1;
                if ($email) {print "| <a href=\"mailto:$email\" target=\"new\">$inputwc</A>";}
            }
            elsif ($msglines[$j] =~ /<website>(.*)<\/website>/) {
                $website = $1;
                if ($website) {print "| <a href=\"$website\" target=\"new\">$inputwc</A>";}
            }
            elsif ($msglines[$j] =~ /<date>(.*)<\/date>/) {
                $date = $1;
                print "\n";
            }
            elsif ($msglines[$j] =~ /<body>/) {
                print "</p><p>\n";
        for ($k=$j+1; $k<@msglines; $k++) {
                    if ($msglines[$k] =~ /<\/body>/) {
                        print "</div>";
                        last;
                    }
                    else {print "$msglines[$k]";}
                    $j++;
                }
            }
        }
    }
}
######################## COMMENTS DISPLAY ONLY ########################
sub parseMessageCom {
    my($filename) = @_;
    my($msgstart, $msgend, @msglines);
    open(DATA,"$forumdir/messages/$filename.txt");
    @msglines = <DATA>;
    close(DATA);
    for ($i=0; $i<@msglines; $i++) {
        if ($msglines[$i] =~ /<msg>/) {push (@msgstart, $i);}
        elsif ($msglines[$i] =~ /<\/msg>/) {push (@msgend, $i);}
    }
    for ($i=0; $i<@msgstart; $i++) {
        for ($j=$msgstart[$i]; $j<$msgend[$i]; $j++) {
            if ($msglines[$j] =~ /<name>(.*)<\/name>/) {
                $name = $1;
                if ($i != 0) {
                    print "<div class=\"comments\"><p>Posted by: $name\n";
                }
                else {print "";}
                print "";
            }
            elsif ($msglines[$j] =~ /<email>(.*)<\/email>/) {
                $email = $1;
                if ($email) {print " from <A HREF=\"$email\" target=\"blank\">Homepage</A>";}
            }
            elsif ($msglines[$j] =~ /<website>(.*)<\/website>/) {
                $website = $1;
                if ($website) {print " (#$website)";}
            }
            elsif ($msglines[$j] =~ /<date>(.*)<\/date>/) {
                $date = $1;
                print "\n";
            }
            elsif ($msglines[$j] =~ /<body>/) {
                print "</p><p>\n";
        for ($k=$j+1; $k<@msglines; $k++) {
                    if ($msglines[$k] =~ /<\/body>/) {
                        print "</div>";
                        last;
                    }
                    else {print "$msglines[$k]";}
                    $j++;
                }
            }
        }
    }
}
######################## TRACKBACK DISPLAY SETTINGS ########################
sub parseMessageDisplay {
    my($filename) = @_;
    my($msgstart, $msgend, @msglines);
    open(DATA,"$forumdir/messages/$filename.txt");
    @msglines = <DATA>;
    close(DATA);
    for ($i=0; $i<@msglines; $i++) {
        if ($msglines[$i] =~ /<msg>/) {push (@msgstart, $i);}
        elsif ($msglines[$i] =~ /<\/msg>/) {push (@msgend, $i);}
    }
    my($replynum) = @_;
              $replynums = ($replynum + 1);
              $replynuml = ($replynum - 1);
    open(DATA,"$forumdir/messages/$replynum.txt");
    @msglines = <DATA>;
    close(DATA);
    for ($i=0; $i<@msglines; $i++) {
        if ($msglines[$i] =~ /<headerfile>(.*)<\/headerfile>/) {$headerfile = $1;}
        elsif ($msglines[$i] =~ /<subject>(.*)<\/subject>/) {$subject = $1;}
    }
    for ($i=0; $i<@msgstart; $i++) {
        for ($j=$msgstart[$i]; $j<$msgend[$i]; $j++) {
            if ($msglines[$j] =~ /<name>(.*)<\/name>/) {
                $name = $1;
                if ($i != 0) {
                    print "
\n";
                }
                else {print "<div class=\"post\"><h2>$subject</h2><div class=\"body\">
<p>$name";}
                print "";
}
                        elsif ($msglines[$j] =~ /<email>(.*)<\/email>/) {
                $email = $1;
                if ($email) {print "<a href=\"mailto:$email\"></a>\n";}
}
                        elsif ($msglines[$j] =~ /<website>(.*)<\/website>/) {
                $website = $1;
                if ($website) {print " (<a href=\"$website\" target=\"new\">website</a>)\n";}
}
                        elsif ($msglines[$j] =~ /<comment>(.*)<\/comment>/) {
                $comment = $1;
                if ($comment) {print " <br />$comment\n";}
}
                        elsif ($msglines[$j] =~ /<date>(.*)<\/date>/) {
                $date = $1;
                print "</p></div><div class=\"tag\"><i>Posted on $date</i><br /><br /></p></div><noscript> \n";
}
                         elsif ($msglines[$j] =~ /<none>/) {
                print "says: <br />\n";
        for ($k=$j+1; $k<@msglines; $k++) {
                    if ($msglines[$k] =~ /<\/comment>/) {
                        print "<br />posted on $date<br /><br /></p></noscript>";
                        last;
                    }
                    else {print "$msglines[$k]";}
                    $j++;
                }
            }
        }
    }
}
######################## TRACKBACK DISPLAY PAGE ########################
sub displayDisplay {
    my($replynum) = @_;
              $replynums = ($replynum + 1);
              $replynuml = ($replynum - 1);
    open(DATA,"$forumdir/messages/$replynum.txt");
    @msglines = <DATA>;
    close(DATA);
for ($i=0; $i<@msglines; $i++) {
        if ($msglines[$i] =~ /<headerfile>(.*)<\/headerfile>/) {$headerfile = $1;}
        elsif ($msglines[$i] =~ /<subject>(.*)<\/subject>/) {$subject = $1;}
    }
    $month = substr ($headerfile,3,6);
    $month = sprintf("%5.0f", $month);
    $monthname = $months[$month-1];
    &printHeader("");
    print <<"EOF";
<br />
EOF
    &printSidemenu;
    print <<"EOF";
</div></div>
<div id="areabox">
EOF
    &parseMessageDisplay ($replynum);
    print <<"EOF";
</noscript></div></div>
EOF
    &printFooter;
}
######################## YOUR JOURNAL ENTRY PAGE ########################
sub displaySubmit {
    &printHeader("");
    print <<"EOF";
<br />
EOF
    &printSidemenu;
    print <<"EOF";
</div></div><div id="areabox">
<div class="post">    
<h2>Write a New Post</h2><br /><font size="1">If you would like to edit/delete any previous posts, <a href="weblog-admin.pl">click here</a><p></font>
<div class="body">
<FORM NAME="forum" ACTION="access.pl?preview" METHOD="POST">
<INPUT TYPE="HIDDEN" NAME="date" VALUE="$todaysdate">
<INPUT TYPE="HIDDEN" NAME="headerfile" VALUE="$newheaderfile">
<TABLE BORDER=0 CELLSPACING=0 CELLPADDING=0></p>
<p><input type="text" class="txt" name="username" size="35" maxlength="225">
<label for="username">Username</label></p>
<p><input type="password" class="txt" name="password" size="35" maxlength="225">
<label for="username">Password</label></p>
<p><input type="text" class="txt" name="subject" size="35" maxlength="225">
<label for="subject">Date (or Title)</label></p><br />
<p>Enter new post below. Use <a href="http://www.w3schools.com/html/html_reference.asp" target="_blank">HTML Tag Assistance</a> if needed.<br />
<script src="$ssource/quicktags.js" type="text/javascript"></script>
<script type="text/javascript">edToolbar();</script>
<textarea style="overflow:hidden" class="entrytext" background="#ddd" cols="70" rows="15" name="name" wrap="physical"></textarea><script src="$ssource/clear.js" type="text/javascript"></script></p>
<p>If your password is incorrect you will have to retype entry.</p><br /><p><INPUT TYPE="Submit" class='submit' VALUE="Post Entry">
</p></FORM></div></div></div>
EOF
}
######################## VISITOR DOCKED COMMENTS PAGE ########################
sub displayReply {
    my($replynum) = @_;
    open(DATA,"$forumdir/messages/$replynum.txt");
    @msglines = <DATA>;
    close(DATA);
    for ($i=0; $i<@msglines; $i++) {
        if ($msglines[$i] =~ /<headerfile>(.*)<\/headerfile>/) {$headerfile = $1;}
        elsif ($msglines[$i] =~ /<subject>(.*)<\/subject>/) {$subject = $1;}
    }
    &printHeader("");
    print <<"EOF";
<br />
EOF
    &printSidemenu;
    print <<"EOF";
</div></div><div id="areabox"><div class="post"><h2>$subject</B></h2><div class="comments">
<FORM NAME="forum" ACTION="?preview" METHOD="POST">
<INPUT TYPE="HIDDEN" NAME="date" VALUE="$todaysdate">
<INPUT TYPE="HIDDEN" NAME="headerfile" VALUE="$headerfile">
<INPUT TYPE="HIDDEN" NAME="subject" VALUE="Re: $subject">
<INPUT TYPE="HIDDEN" NAME="reply" VALUE="$replynum"><p>
EOF
    &parseMessageData ($replynum);
    print <<"EOF";
</p></div><h2 id="postcomment">Leave a comment</h2><div class="body"><p>Line and paragraph breaks automatic, e-mail addresses will be displayed, <acronym title="Hypertext Markup Language">HTML</acronym> allowed: <code>&lt;a href=&quot;&quot; title=&quot;&quot; rel=&quot;&quot;&gt; &lt;abbr title=&quot;&quot;&gt; &lt;acronym title=&quot;&quot;&gt; &lt;b&gt; &lt;blockquote cite=&quot;&quot;&gt; &lt;code&gt; &lt;em&gt; &lt;i&gt; &lt;strike&gt; &lt;strong&gt; </code></p><p>&nbsp;</p>
<p><INPUT TYPE="TEXT" class="txt" NAME="name" SIZE="25" MAXLENGTH="25" tabindex="1" />
  <label for="author">Name</label> 
</p><p>
<INPUT TYPE="TEXT" class="txt" NAME="email" SIZE="25" tabindex="2" />
  <label for="website">Website (optional)</label> 
</p><p>
   <label for="message">Your Message</label><br />
<TEXTAREA STYLE="overflow:hidden" class="entrytext" background="#E8E9EC" COLS=50 ROWS=9 NAME="body" WRAP="Physical" tabindex="4"></TEXTAREA>
</p><p>&nbsp;</p><p>
<INPUT TYPE="Submit" class='submit' VALUE="Post Comment" tabindex="4">
</p></FORM></div></div>
EOF
        &printFooter;
             }
######################## VISITOR POPUP COMMENTS PAGE ########################
sub displayPopupreply {
    my($replynum) = @_;
    open(DATA,"$forumdir/messages/$replynum.txt");
    @msglines = <DATA>;
    close(DATA);
    for ($i=0; $i<@msglines; $i++) {
        if ($msglines[$i] =~ /<headerfile>(.*)<\/headerfile>/) {$headerfile = $1;}
        elsif ($msglines[$i] =~ /<subject>(.*)<\/subject>/) {$subject = $1;}
    }
    &printNeader("");
    print <<"EOF";
<br />
<div class="commentbox"><h2>$subject</B></h2><div class="comments">
<FORM NAME="forum" ACTION="?popreview" METHOD="POST">
<INPUT TYPE="HIDDEN" NAME="date" VALUE="$todaysdate">
<INPUT TYPE="HIDDEN" NAME="headerfile" VALUE="$headerfile">
<INPUT TYPE="HIDDEN" NAME="subject" VALUE="Re: $subject">
<INPUT TYPE="HIDDEN" NAME="reply" VALUE="$replynum"><p>
EOF
     if ($cpost eq "no") {
        &parseMessageCom ($replynum);
    }
    if ($cpost eq "yes") {
        &parseMessageData ($replynum);
    }
    print <<"EOF";
</p></div></noscript><div class="commentbox"><h2>Leave a comment</h2><p>Line and paragraph breaks automatic, e-mail addresses will be displayed, <acronym title="Hypertext Markup Language">HTML</acronym> allowed: <code>&lt;a href=&quot;&quot; title=&quot;&quot; rel=&quot;&quot;&gt; &lt;abbr title=&quot;&quot;&gt; &lt;acronym title=&quot;&quot;&gt; &lt;b&gt; &lt;blockquote cite=&quot;&quot;&gt; &lt;code&gt; &lt;em&gt; &lt;i&gt; &lt;strike&gt; &lt;strong&gt; </code></p>
<p><INPUT TYPE="TEXT" class="txt" NAME="name" SIZE="25" MAXLENGTH="25" tabindex="1" />
  <label for="author">Name</label> 
</p><p>
EOF
     if ($inputwc eq "website") {
        print "<input type=\"text\" class=\"txt\" name=\"website\" size=\"25\" tabindex=\"2\" /><label for=\"website\"> Website (optional, include http://)</label>";
    }
     if ($inputwc eq "email") {
        print "<input type=\"text\" class=\"txt\" name=\"email\" size=\"25\" tabindex=\"2\" /><label for=\"email\"> Email</label>";
    }
    print <<"EOF";
</p>
<p>
  <label for="message">Your Message</label><br />
<TEXTAREA STYLE="overflow:hidden" class="entrytext" background="#E8E9EC" COLS=50 ROWS=9 NAME="body" WRAP="Physical" tabindex="4"></TEXTAREA>
</p><p>
<INPUT TYPE="Submit" class='submit' VALUE="Post Comment" tabindex="4">
</p></FORM></div></div>
EOF
             }
######################## PREVIEW PAGE FOR POPUP VISITORS ########################
sub displayPopPreview {
    $name = $in{'name'};
    $name =~ s/</&lt;/g;
    $name =~ s/>/&gt;/g;
    $name =~ s/"/&quot;/g;
    $image = $in{'image'};
    $image =~ s/</&lt;/g;
    $image =~ s/>/&gt;/g;
    $image =~ s/"/&quot;/g;
    $postm= $in{'postm'};
    $postm =~ s/</&lt;/g;
    $postm =~ s/>/&gt;/g;
    $postm =~ s/"/&quot;/g;
    $email = $in{'email'};
    $email =~ s/<([^>]|\n)*>//g;
    $website = $in{'website'};
    $website =~ s/<([^>]|\n)*>//g;
    $date= $in{'date'};
    $headerfile = $in{'headerfile'};
    $subject = $in{'subject'};
    $reply = $in{'reply'};
    $body = $in{'body'};
    $body =~ s/\cM//g;
    $body =~ s/</&lt;/g;
    $body =~ s/>/&gt;/g;
    $body =~ s/\n/<br \/>/g;   
    $body =~ s/"/&quot;/g;
    if ($html eq "no") {
        $bodyshow =~ s/<([^>]|\n)*>//g;
    }
    if ($html eq "yes") {
        $bodyshow =~ s/</&lt;/g;
        $bodyshow =~ s/>/&gt;/g;
        $bodyshow =~ s/"/&quot;/g;
    }
    $subject =~ s/\cM//g;
    $subject =~ s/<([^>]|\n)*>//g;
    $subject =~ s/"/&quot;/g;
    $subject =~ s/_/ /g;
    &printNeader("");
    if ($name) {
        print "\n";
        if ($email) {
            print "\n";
  if ($website) {
            print " (#$website)\n";
        }
        }
        print <<"EOF";
<div class="commentbox"><br /><h2>Preview</h2>
<br /><span class="text">Name: $name
<br />Date: $date
<br />Comment: $body
<form name="forum" method=post action="weblog.pl">
<input type="hidden" name="date" value="$date">
<input type="hidden" name="headerfile" value="$headerfile">
<input type="hidden" name="name" value="$name">
<input type="hidden" name="image" value="$image">
<input type="hidden" name="email" value="$email">
<input type="hidden" name="website" value="$website">
<input type="hidden" name="subject" value="$subject">
<input type="hidden" name="body" value="$body">
<p><br />
<input class="submit" type="button" value="Edit" onClick="history.back()">
<input class="submit" type="submit" value="Post Comment">
EOF
        if ($reply) {
            print "<input type=\"Hidden\" name=\"post\" value=\"reply\">\n";
            print "<input type=\"Hidden\" name=\"reply\" value=\"$reply\">\n";
        }
        else {
            print "<input type=\"Hidden\" name=\"post\" value=\"thread\">\n";
        }
        print "</form></td></tr></table>\n";
    }
    else {
        print "
<div class=\"commentbox\"><br /><h2>Error</h2><br /><p>Error: You are required to give a name and a message</span><p><br /><input class=\"submit\" type=\"Button\" value=\"Edit\" onClick=\"history.back()\"><br /><br /></p>";
             }
}
######################## PREVIEW PAGE FOR DOCKED VISITORS ########################
sub displayPreview {
    $name = $in{'name'};
    $name =~ s/</&lt;/g;
    $name =~ s/>/&gt;/g;
    $name =~ s/"/&quot;/g;
    $image = $in{'image'};
    $image =~ s/</&lt;/g;
    $image =~ s/>/&gt;/g;
    $image =~ s/"/&quot;/g;
    $postm= $in{'postm'};
    $postm =~ s/</&lt;/g;
    $postm =~ s/>/&gt;/g;
    $postm =~ s/"/&quot;/g;
    $email = $in{'email'};
    $email =~ s/<([^>]|\n)*>//g;
    $website = $in{'website'};
    $website =~ s/<([^>]|\n)*>//g;
    $date= $in{'date'};
    $headerfile = $in{'headerfile'};
    $subject = $in{'subject'};
    $reply = $in{'reply'};
    $body = $in{'body'};
    $body =~ s/\cM//g;
    $body =~ s/</&lt;/g;
    $body =~ s/>/&gt;/g;
    $body =~ s/\n/<br \/>/g;   
    $body =~ s/"/&quot;/g;
    if ($html eq "no") {
        $bodyshow =~ s/<([^>]|\n)*>//g;
    }
    if ($html eq "yes") {
        $bodyshow =~ s/</&lt;/g;
        $bodyshow =~ s/>/&gt;/g;
        $bodyshow =~ s/"/&quot;/g;
    }
    $subject =~ s/\cM//g;
    $subject =~ s/<([^>]|\n)*>//g;
    $subject =~ s/"/&quot;/g;
    $subject =~ s/_/ /g;
    &printHeader("");
    if ($name) {
        print "\n";
        if ($email) {
            print "\n";
  if ($website) {
            print " (#$website)\n";
        }
        }
        print <<"EOF";
<table cellpadding="10" cellspacing="1" border="0" width="50%" align="center" class="border">
<tr><td width="0%" valign="top" colspan="2"><br /><h2>Preview</h2>
<br /><span class="text">Name: $name
<br />Date: $date
<br />Comment: $body
<form name="forum" method=post action="weblog.pl">
<input type="hidden" name="date" value="$date">
<input type="hidden" name="headerfile" value="$headerfile">
<input type="hidden" name="name" value="$name">
<input type="hidden" name="image" value="$image">
<input type="hidden" name="email" value="$email">
<input type="hidden" name="website" value="$website">
<input type="hidden" name="subject" value="$subject">
<input type="hidden" name="body" value="$body">
<p><br />
<input class="submit" type="button" value="Edit" onClick="history.back()">
<input class="submit" type="submit" value="Post Comment">
<p>&nbsp;</p>
EOF
        if ($reply) {
            print "<input type=\"Hidden\" name=\"post\" value=\"reply\">\n";
            print "<input type=\"Hidden\" name=\"reply\" value=\"$reply\">\n";
        }
        else {
            print "<input type=\"Hidden\" name=\"post\" value=\"thread\">\n";
        }
        print "</form></td></tr></table>\n";
    }
    else {
        print "
<table cellpadding=\"10\" cellspacing=\"1\" border=\"0\" width=\"50%\" align=\"center\" class=\"border\"><tr><td width=\"0%\" valign=\"top\" colspan=\"2\"><br /><h2>Error</h2><br />Error: You are required to give a name, an email address and a message</span><p><br /><input class=\"submit\" type=\"Button\" value=\"Edit\" onClick=\"history.back()\"><br /><br /></td></tr></table>";
             }
    &printFooter;
}
######################## WRAP TEXT ########################
sub wrapText {
    my($body,$length) = @_;
    @lines = split(/\n/,$body);
    $newstr = "";
    for ($i=0; $i<@lines; $i++) {
        @words = split(/ /,@lines[$i]);
        $block = $words[0];
        for ($j=1; $j<@words; $j++) {
            $word = $words[$j];
            $test = $block." ".$word;
            if (split(//,$test) < $length+1) {
                $block = $block." ".$word;
            }
            else {
                $newstr = $newstr.$block."\n";
                $block = $word;
            }
        }
        $newstr = $newstr.$block."\n";
    }
    return ($newstr);
}

######################## DETERMINES ENTRY OR REPLY ########################
sub postMessage {
    $name = $in{'name'};
    $postm = $in{'postm'};
    $image = $in{'image'};
    $email = $in{'email'};
    $website = $in{'website'};
    $date = $in{'date'};
    $headerfile = $in{'headerfile'};
    $reply = $in{'reply'};
    $body = $in{'body'};
    $body =~ s/\cM//g;
    $body =~ s/\n/<br \/>/g;
    if ($html eq "no") {
        $body =~ s/<([^>]|\n)*>//g;
    }
    if ($html eq "yes") {
        $body =~ s/</&lt;/g;
        $body =~ s/>/&gt;/g;
        $body =~ s/"/&quot;/g;
    }
    $subject = $in{'subject'};
    $subject =~ s/\cM//g;
    $subject =~ s/"/&quot;/g;
    $subject =~ s/_/ /g;
    if ($in{'post'} eq "thread") {&postThread;}
    elsif ($in{'post'} eq "reply") {&postReply;}
    if ($reply) {$message = $reply;}
    else {$message = $num;}
    print <<"EOF";
EOF
    if ($in{'post'} eq "thread") {
            &printHeader ("");
       print "<table cellpadding=\"10\" cellspacing=\"1\" border=\"0\" width=\"50%\" align=\"center\" class=\"border\" summary=\"Your post has been successfully posted\"><tr><td width=\"0%\" valign=\"top\" colspan=\"2\"><br /><h2>Success</h2><br /><span class=\"text\">Your entry has successfully been posted!<br /><br /><a href=\"weblog.pl\" title=\"Return to my weblog\">Return to weblog</a><br /><br /></span></td></tr></table>";
    }
    elsif ($in{'post'} eq "reply")  {
    if ($popup eq "no") {
            &printHeader ("");
       print "<table cellpadding=\"10\" cellspacing=\"1\" border=\"0\" width=\"50%\" align=\"center\" class=\"border\" summary=\"Your comment has been successfully posted\"><tr><td width=\"0%\" valign=\"top\" colspan=\"2\"><br /><h2>Thank you</h2><br /><span class=\"text\">Your comment has successfully been posted!<br /><br /><a href=\"weblog.pl\" title=\"Return to my weblog\">Return to weblog</a><br /><br /></span></td></tr></table>";
    }
    if ($popup eq "yes") {
            &printNeader ("");
        print "<div class=\"commentbox\"><br /><h2>Thank you</h2><br /><p>Your comment has successfully been posted!</p><p><a href=\"weblog.pl?popup=$message\" title=\"Return to the comment box\">Return to the comment box</a></p></span></div><noscript>";
}
    }
    print <<"EOF";
EOF
    &printFooter;
}

######################## POSTS NEW ENTRY ########################
sub postThread {
    if (!opendir (DIR, "$forumdir")) {
        mkdir ("$forumdir", 0700);
    }
    open(NUM,"$forumdir/num.txt");
    $num = <NUM>;
    $num += 1;
    close(NUM);
    open(NUM,">$forumdir/num.txt");
    print NUM $num;
    close(NUM);

    open(MONTHS,"$forumdir/months.txt");
    @months = <MONTHS>;
    close(MONTHS);

    open(ALL,"$forumdir/all.txt");
    @headers = <ALL>;
    close(ALL);
    open(ALL,">$forumdir/all.txt");
    unshift (@headers, "$num\_$subject\_$name\_$image\_$postm\_$date\_0\_&nbsp;\n");  # JHT modified: last field - &nbsp;
    foreach $headerline (@headers) {
        print ALL $headerline;
    }
    $addit = "true";
    foreach $month (@months) {
        if ($month =~ /$headerfile/) {
            $addit = "false";
        }
    }
    if ($addit eq "true") {
        open(MONTHS,"$forumdir/months.txt");
        @monthlines = <MONTHS>;
        close(MONTHS);
        open(MONTHS,">$forumdir/months.txt");
        unshift (@monthlines, "$headerfile\n");
        foreach $monthline (@monthlines) {
            print MONTHS $monthline;
        }
        close(MONTHS);
    }
    
    open(HEADER,"$forumdir/$headerfile.txt");
    @headers = <HEADER>;
    close(HEADER);
    open(HEADER,">$forumdir/$headerfile.txt");
    unshift (@headers, "$num\_$subject\_$name\_$image\_$postm\_$date\_0\_&nbsp;\n");  # JHT modified: last field - &nbsp;
    foreach $headerline (@headers) {
        print HEADER $headerline;
    }

    close(HEADER);
    if (!opendir (DIR, "$forumdir/messages")) {
        mkdir ("$forumdir/messages", 0777);
    }
    open(NEWTHREAD,">$forumdir/messages/$num.txt");
    print NEWTHREAD <<"EOF";
<threadinfo>
<num>$num</num>
<headerfile>$headerfile</headerfile>
<subject>$subject</subject>
</threadinfo>

<msg>
<name>$name</name>
<email>$email</email>
<website>$website</website>
<image>$image</image>
<date>$date</date>
<body>
$body
</body>
</msg>
EOF
    close(NEWTHREAD);
}

######################## POSTS NEW REPLY ########################
sub postReply {
    open(HEADER,"$forumdir/$headerfile.txt");
    @headers = <HEADER>;
    close(HEADER);
    open(HEADER,">$forumdir/$headerfile.txt");
    foreach $headerline (@headers) {
        @headerdata = split(/_/, $headerline);
        $threadnum = $headerdata[0];
        if ($threadnum == $reply) {
            @headerdata = split(/_/, $headerline);
            $responses = $headerdata[6];
            $responses += 1;
            $replytime = $date;    # replytime is JHT addition
            print HEADER "$headerdata[0]\_$headerdata[1]\_$headerdata[2]\_$headerdata[3]\_$headerdata[4]\_$headerdata[5]\_$responses\_&nbsp;\n";
        }
        else {print HEADER "$headerline";}
    }
    close(HEADER);

    open(ALL,">$forumdir/all.txt");
    foreach $headerline (@headers) {
        @headerdata = split(/_/, $headerline);
        $threadnum = $headerdata[0];
        if ($threadnum == $reply) {
            @headerdata = split(/_/, $headerline);
            $responses = $headerdata[6];
            $responses += 1;
            $replytime = $date;    # replytime is JHT addition
            print ALL "$headerdata[0]\_$headerdata[1]\_$headerdata[2]\_$headerdata[3]\_$headerdata[4]\_$headerdata[5]\_$responses\_&nbsp;\n";
        }
        else {print ALL "$headerline";}
    }
    close(ALL);
    open(REPLY,">>$forumdir/messages/$reply.txt");
    print REPLY <<"EOF";

<msg>
<name>$name</name>
<email>$email</email>
<website>$website</website>
<date>$date</date>
<body>
$body
</body>
</msg>
EOF
    close(REPLY);
}
######################## BARE HEADER FOR COMMENTS PAGE ########################
sub printNeader {
    my($title) = @_;
print "Content-type: text/html\n\n";
    print <<"EOF";
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">

<html xmlns="http://www.w3.org/1999/xhtml" lang="en" xml:lang="en">
<head>
<TITLE>$blogtitle</TITLE>
<meta name="description" content="$description" />
<meta name="keywords" content="$keywords" />
<meta name="author" content="$author" />
<style>
html { height: 100%; }
* { padding: 0; border: 0; margin: 0; }
body { font-family: $bodyfont; background-color: $popccolor;font-size:$fontsz; color:$bodycolor;border: 0px; height: 100%; margin: 0px; padding: 0px;letter-spacing: 0px; line-height: 1.5em; }
.commentbox { color:$pocolor;width: $cowidth; background: $popccolor url($headerimg) no-repeat top center; margin: 0 auto; padding-left:10px; }
.comments { color:$pocolor;width: $cowidth; text-align:justify;font-family:$bodyfont;border-bottom-color: $bodycolor; border-bottom-style: dotted; border-bottom-width: 1px; padding-bottom: 3px; margin-top: 3px; margin-bottom: 10px; border-color: $bodycolor;} 
h2, .h2 {font-family: $titlefont; font-size: $tentrysize; line-height: normal; padding-bottom:0.3em;font-weight: bold; color: $pocolor;}
a:link, a:visited, a:active { text-decoration: $linkdeco; color: $linkcolor;font-weight:$linkweight; }
a:hover{ text-decoration: $txtdecohover; color:$hover; font-weight:$fntweight; }
img { border: none; }
p img { padding:$imgpadding; border:1px solid $imgborder; background-color:$imgback; }
p { margin: 0 0 12px 0; padding: 0;}
textarea { width: 340px; }
input.txt { background-color:$inputbg; border: 1px $inputborder solid; padding: 1px; font: $inputfsize $inputfont; color: $inputcolor; }
textarea.entrytext { background-color:$inputbg;overflow: hidden; border: 1px $inputborder solid; padding: 1px; font: $inputfsize $inputfont; color: $inputcolor; }
input.submit { font-family:$submitfont; font-size:$submitfontsize; background-color: $submitbg; color:$submitfontcolor; border-top: $submitborder 1px solid; border-left:$submitborder 1px solid; border-right: $submitborder 1px solid; border-bottom: $submitborder 1px solid; }
</style>
</head><body>
EOF
}
######################## HEADER FOR ALL PAGES ########################
sub printHeader {
    my($title) = @_;
print "Content-type: text/html\n\n";
    print <<"EOF";
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">

<html xmlns="http://www.w3.org/1999/xhtml" lang="$lang" xml:lang="$lang">
<head>
<title>$blogtitle</title>
<meta http-equiv="content-type" content="text/html; charset=$charset" />
<meta name="description" content="$description" />
<meta name="keywords" content="$keywords" />
<meta name="author" content="$author" />
<style type="text/css">
html { height: 100%; }
* { padding: 0; border: 0; margin: 0; }
body { font-family: $bodyfont; background-color: $bgcolor;font-size:$fontsz; color:$bodycolor;border: 0px; height: 100%; margin: 0px; padding: 0px;letter-spacing: 0px; line-height: 1.5em; }
.body p {font-family:$bodyfont; color:$bodycolor;font-size:$bodyesize; }
.body { margin-bottom: 2em; margin-top: 1em; } 
.body { text-align:justify; }
.subtitle { width: $width; height:$sheight; background: $bgtopcolor; margin: 0 auto; padding-top: $subtitlepaddingtop; color:#ffffff; }
.headerlinks { width: $width; height:$hheight; background: $bgtopcolor; margin: 0 auto; }
.headerlinks p { padding-top: $headerpaddingtop; padding-left: $paddinglft; color:$brackets; }
.top { padding-top:$paddingtp; width: $width; height:$height; background: $bgtopcolor url($headerimg) no-repeat top center; margin: 0 auto; }
.footer { width: $width; height:$footerheight; background: $footercolor url($footerimg) no-repeat bottom center; }
.footer p { padding-top:10px; padding-left:$paddinglft; color:$footertxt; font-family:$footerfont; font-size:$footersize; }
.footer a:link, a:visited, a:active { color: $footerlinks; text-decoration: $footerdecoration; }
.footer a:hover { color: $footerhover; text-decoration: $footerhdecoration; }
.banner { width: $width; background: $maincolor  repeat-y center url($bgimg); margin: 0 auto; }
#areabox {width: $jwidth;  margin-bottom: 60px;padding-top:10px; padding-left:$paddinglft; padding-bottom: 20px; min-height: 400px; }
#sidebar { background-color:$sidebarcolor;float: $direction; width: $swidth;padding-top:10px; padding-right:$paddingr; padding-left:$paddingl; }
a.subtitle:link, a.subtitle:visited, a.subtitle:active {margin-left: $paddinglft; font-family:$subttfont;text-decoration: none; color: $subttcolor; font-size:$subtitlesize; text-decoration:$subttdeco; font-weight:$subtitlewg; }
a.subtitle:hover {font-family:$subtthfont;text-decoration: none; color: $subtthcolor; font-size:$subtitlehsize; text-decoration:$subtthdeco; font-weight:$subtitlehpwg; }
p a.subtitlelink:link, p a.subtitlelink:visited, p a.subtitlelink:active {font-family:$subttfontl;text-decoration: none; color: $subttcolorl; font-size:$subtitlesizel; text-decoration:$subttdecol; font-weight:$subtitlewgl; }
p a.subtitlelink:hover {font-family:$subtthfontl;text-decoration: none; color: $subtthcolorl; font-size:$subtitlehsizel; text-decoration:$subtthdecol; font-weight:$subtitlehpwgl; }
a.title:link, a.title:visited, a.title:active {margin-left:$paddinglft; font-family:$headertitlefont;text-decoration: none; 
color:$headertitlecolor;font-size:$titlesize;font-weight:$headertitlewg;border-bottom: none; }
h2, .h2 {font-family: $titlefont; font-size: $tentrysize; line-height: normal; padding-bottom:0.3em;font-weight: bold; color: $titlecolor; }
.comments {font-family:$bodyfont;border-bottom-color: $bodycolor; border-bottom-style: dotted; border-bottom-width: 1px; padding-bottom: 3px; margin-top: 3px; margin-bottom: 10px; border-color: $bodycolor; } 
.section { font-family: $sectionfont; font-size: $sectionsize; text-align: left; line-height: 1.4em; margin-bottom: 22px; color: $sectionclr; }
.tag {font-family:$tagfont; font-weight:$tagweight; color:$tagcolor; font-size:$tagfontsize; }
a:link, a:visited, a:active { text-decoration: $linkdeco; color: $linkcolor;font-weight:$linkweight; }
a:hover{ text-decoration: $txtdecohover; color:$hover; font-weight:$fntweight; }
img { border: none; }
p img { padding:$imgpadding; border:1px solid $imgborder; background-color:$imgback; }
textarea { width: 340px; }
input.txt { background-color:$inputbg; border: 1px $inputborder solid; padding: 1px; font: $inputfsize $inputfont; color: $inputcolor; }
textarea.entrytext { background-color:$inputbg;overflow: hidden; border: 1px $inputborder solid; padding: 1px; font: $inputfsize $inputfont; color: $inputcolor; }
input.submit { font-family:$submitfont; font-size:$submitfontsize; background-color: $submitbg; color:$submitfontcolor; border-top: $submitborder 1px solid; border-left:$submitborder 1px solid; border-right: $submitborder 1px solid; border-bottom: $submitborder 1px solid; }
.section .caption {border-bottom-color: $bodycolor; border-bottom-style: dotted; border-bottom-width: 1px; font-weight: $sidefweight; font-size: $sectionfsize; font-family: $sectiontfont; padding-bottom: 3px; margin-top: 3px; margin-bottom: 10px; color: $sidefcolor; border-color: $bodycolor; }
.section p { margin: 0 0 10px 0; padding: 0; line-height:1.4em; }
.section a:link, .section a:visited, .section a:active { font-family:$sectionlfont; color: $sectionlc; size: $sectionls; font-weight:$sectionlwg; text-decoration:$sectiondecol; }
.section a:hover { font-family:$sectionlfonth; color: $sectionlch; size: $sectionlsh; font-weight:$sectionlwgh;text-decoration:$sectiondecolh; }
.description p { margin: 0 0 10px 0; padding: 0; line-height:1.4em; text-align:justify; }
input.ed_button {margin-right:3px; margin-bottom:3px; background-color:#ffffff; border: 1px #4b4b4b solid; padding: 1px; font: 11px Georgia; color: #333333; }
</style></head><body>
<div class="top"><a href="weblog.pl" class="title">$blogtitle</a></div>
<div class="subtitle"><a href="weblog.pl" class="subtitle">$subtitle</a></div>
<div class="headerlinks"><p>
                    [ <a href="weblog.pl" class="subtitlelink">main</a> | 
                      <a href="?archives" class="subtitlelink">archives</a> | 
                      <a href="?about" class="subtitlelink">about</a> ]</p>
</div>
<div class="banner">
EOF
}
######################## SIDEBAR RECALL ########################
 sub printSidemenu {
    print <<"EOF";
EOF
                  open SIDEBAR, "$forumdir/sidebar.txt"
         or die "Can't open header file because $!\n";
     print while (<SIDEBAR>);
    close SIDEBAR;
}
######################## ABOUT PAGE RECALL ########################
 sub printAboutPage {
    print <<"EOF";
EOF
                  open SIDEBAR, "$forumdir/about.txt"
         or die "Can't open header file because $!\n";
     print while (<SIDEBAR>);
    close SIDEBAR;
}
######################## FOOTER RECALL ########################
 sub printFooter {
 print <<"EOF";
<div class="footer"><p>
EOF
    open FOOTER, "$forumdir/footer.txt"
         or die "Can't open footer file because $!\n";
     print while (<FOOTER>);
    close FOOTER;
}
    print "\n</p></div></div></body></html>\n\n";